<?php

namespace SslWireless;

class SslWirelessSms
{

    private $url = 'https://portal.shadhinsms.com/admin/index.php?route=api/sms/send&auth_key=yS19T8lQNgBbgDAg8vkjxKQervVVMbpEOHwByDYN&device_id=1&sim_id=4&data_type=text&user_id=1';

    /**
     * Send the message to desired number
     *
     * @param $phone
     * @param $message
     * @return string
     */
    function send($phone, $message)
    {
        $url = $this->url;
        $data = [
            'sms[0][0]' => $mobile_no,
            'sms[0][1]' => $message,
            'sms[0][2]' => random_int(1, 99999999),
            'sid' => $this->sid
        ];

        // key 'http' is same for both http and https
        $options = [
            'http' => [
                'header' => "Content-type: application/x-www-form-urlencoded",
                'method' => 'POST',
                'content' => http_build_query($data)
            ]
        ];

        $context = stream_context_create($options);
        $result = file_get_contents($url, false, $context);

        $parsed_result = simplexml_load_string($result);

        if ($parsed_result->SMSINFO->REFERENCEID) {

            return json_decode(json_encode([
                'status' => 'success',
                'result' => 'sms sent',
                'phone' => $phone,
                'message' => $message,
                'reference_no' => $parsed_result->SMSINFO->CSMSID,
                'ssl_reference_no' => $parsed_result->SMSINFO->REFERENCEID,
                'datetime' => date('Y-m-d H:ia')
            ]));

        }
        elseif ($parsed_result->SMSINFO->SMSVALUE) {

            return json_decode(json_encode([
                'status' => 'failed',
                'result' => 'invalid mobile or text',
                'phone' => $phone,
                'message' => $message,
                'reference_no' => '',
                'ssl_reference_no' => '',
                'datetime' => date('Y-m-d H:ia')
            ]));

        }
        elseif ($parsed_result->SMSINFO->MSISDNSTATUS) {

            return json_decode(json_encode([
                'status' => 'failed',
                'result' => 'invalid mobile no',
                'phone' => $phone,
                'message' => $message,
                'reference_no' => '',
                'ssl_reference_no' => '',
                'datetime' => date('Y-m-d H:ia')
            ]));

        }
        else {

            return json_decode(json_encode([
                'status' => 'failed',
                'result' => 'invalid credentials',
                'phone' => $phone,
                'message' => $message,
                'reference_no' => '',
                'ssl_reference_no' => '',
                'datetime' => date('Y-m-d H:ia')
            ]));

        }

    }

}