<?php
    $user_role = auth()->user()->role;
    $admin  = 1;
?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.package_list')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    
    <!--begin::Card-->
    <div class="card">
        <!--begin::Card header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Card title-->
            <div class="card-title">

                <!--begin::Search-->
                
                <?php echo $__env->make('adminLte.components.modules.datatable.search', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!--end::Search-->

            </div>
            <!--begin::Card title-->

            <!--begin::Card toolbar-->
            <div class="card-toolbar">
                <!--begin::Toolbar-->
                <div class="d-flex flex-wrap align-items-center" id="<?php echo e($table_id); ?>_custom_filter">
                    
                    <?php echo $__env->make('adminLte.components.modules.datatable.datatable_length', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                    <?php echo $__env->make('adminLte.components.modules.datatable.reload', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if(auth()->user()->can('export-table-packages') || $user_role == $admin ): ?>
                        <!-- ================== begin export buttons =============================== -->
                        <?php echo $__env->make('adminLte.components.modules.datatable.export', ['table_id' => $table_id, 'btn_exports' => $btn_exports], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <!-- ================== end export buttons =============================== -->
                    <?php endif; ?>

                    <!--begin::Add user-->
                    <?php if(auth()->user()->can('create-packages') || $user_role == $admin ): ?>
                        <a href="<?php echo e(fr_route('packages.create')); ?>" class="btn btn-primary m-1"><?php echo e(__('cargo::view.add_package')); ?></a>
                    <?php endif; ?>
                    <!--end::Add user-->
                </div>
                <!--end::Toolbar-->

                <!--begin::Group actions-->
                <?php echo $__env->make('adminLte.components.modules.datatable.columns.checkbox-actions', [
                    'table_id' => $table_id,
                    'permission' => 'delete-packages',
                    'url' => fr_route('packages.multi-destroy'),
                    'callback' => 'reload-table',
                    'model_name' => __('cargo::view.selected_packages')
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!--end::Group actions-->

            </div>
            <!--end::Card toolbar-->
        </div>
        <!--end::Card header-->


        <!--begin::Card body-->
        <div class="card-body pt-6">

            <!--begin::Table-->
            <?php echo e($dataTable->table()); ?>

            <!--end::Table-->


        </div>
        <!--end::Card body-->
    </div>
    <!--end::Card-->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('toolbar-btn'); ?>
    <!--begin::Button-->
    
    <!--end::Button-->
<?php $__env->stopSection(); ?>



<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/lte/plugins/custom/datatables/datatables.bundle.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/lte/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <?php echo e($dataTable->scripts()); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Modules/Cargo\Resources/views/adminLte/pages/packages/index.blade.php ENDPATH**/ ?>