<?php
    $user_role = auth()->user()->role;
    $auth_branch = 3;
?>


<?php if(in_array('transaction_owner', $filters)): ?>
    <div class="mb-10">
        <!--begin::Label-->
        <label class="form-label fs-5 fw-bold mb-3"><?php echo e(__('cargo::view.table.owner_type')); ?>:</label>
        <!--end::Label-->
        <!--begin::Options-->
        <div class="d-flex flex-column flex-wrap fw-bold">
            <select class="form-control  select-branch" data-control="select2"
                data-placeholder="<?php echo e(__('cargo::view.table.owner_type')); ?>" data-allow-clear="true"
                name="<?php echo e($table_id); ?>_transaction_owner">
                <option></option>
                <option value="1"><?php echo e(__('cargo::view.driver')); ?></option>
                    <option value="2"><?php echo e(__('cargo::view.client')); ?></option>
                    <?php if($user_role != $auth_branch): ?>
                        <option value="3"><?php echo e(__('cargo::view.table.branch')); ?></option>
                    <?php endif; ?>
            </select>
            <!--end::Option-->
        </div>
        <!--end::Options-->
    </div>

    
    <?php $__env->startPush('js-component'); ?>
        <script>
            $(window).on('load', function() {
                setTimeout(() => {
                    var table_id = '<?php echo e($table_id); ?>';
                    var transaction_ownerSelect = $(`[name="${ table_id }_transaction_owner"]`)
                    var dataTableInstance = $(`#${table_id}`).DataTable();
                    var formOptions = $(`#${table_id}_filter_options_form`);

                    transaction_ownerSelect.on('change', function(e) {
                        var value = $(this).val(),

                            transaction_ownerSelectChecked = transaction_ownerSelect.filter(':checked')
                        // get data by selected roles
                        dataTableInstance.on('preXhr.dt', function(e, settings, data) {
                            if (!data.filter) {
                                data.filter = {}
                            }
                            data.filter.transaction_owner = value;
                        })
                        // dataTableInstance.ajax.reload()
                    })
                    formOptions.on('reset', function(e) {
                        dataTableInstance.on('preXhr.dt', function(e, settings, data) {
                            if (data.filter) {
                                data.filter.transaction_owner = '';
                            }
                        })
                        // dataTableInstance.ajax.reload()
                    })
                }, 1000);
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/transactions/table/transaction_owner.blade.php ENDPATH**/ ?>