<?php
    $user_role = auth()->user()->role;
    $admin  = 1;

    $default_country_cost = Modules\Cargo\Entities\Cost::where('from_country_id',$from->id)->where('to_country_id',$to->id)->where('from_state_id',0)->where('to_state_id',0)->first();
    $is_def_mile_or_fees = Modules\Cargo\Entities\ShipmentSetting::getVal('is_def_mile_or_fees');
    ini_set('max_input_vars', 5000);
?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.package_list')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="col-lg-12 mx-auto">
    <div class="card">
        <form class="form-horizontal" action="<?php echo e(route('countries.config.costs')); ?>" id="kt_form_1" method="GET" enctype="multipart/form-data">
            <input type="hidden" name="from_country" value="<?php echo e($from->id); ?>">
            <input type="hidden" name="to_country" value="<?php echo e($to->id); ?>">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-4">
                        <label><?php echo e(__('cargo::view.from_region')); ?>:</label>
                        <select name="from_region" class="form-control select-country" required>
                            <option value=""></option>

                            <?php $__currentLoopData = $from_cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $covered): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($covered->id); ?>" <?php if(isset($from_region) && $from_region->id == $covered->id): ?> selected <?php endif; ?>><?php echo e($covered->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label><?php echo e(__('cargo::view.to_region')); ?>:</label>
                        <select name="to_region" class="form-control select-country" required>
                            <option value=""></option>
                            <?php $__currentLoopData = $to_cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $covered): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($covered->id); ?>" <?php if(isset($to_region) && $to_region->id == $covered->id): ?> selected <?php endif; ?>><?php echo e($covered->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label><?php echo e(__('cargo::view.configure_costs')); ?>:</label>
                        <button class="btn btn-primary form-control"><?php echo e(__('cargo::view.configure_selected_regions_costs')); ?></button>
                    </div>


                </div>
            </div>
        </form>

        <form class="form-horizontal" action="<?php echo e(route('post.countries.config.costs')); ?>?from_country=<?php echo e($from->id); ?>&to_country=<?php echo e($to->id); ?>" id="kt_form_1" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card-header">
                <h5 class="mb-0 h6"><?php echo e(__('cargo::view.from')); ?>: ( <?php echo e($from->name); ?> ) | <?php echo e(__('cargo::view.to')); ?>: ( <?php echo e($to->name); ?>)</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo e(__('cargo::view.from_country')); ?>:</label>
                                <input disabled readonly class="form-control disabled" value="<?php echo e($from->name); ?>">
                                <input type="hidden" name="from_country_h[]" value="<?php echo e($from->id); ?>">
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo e(__('cargo::view.to_country')); ?>:</label>
                                <input disabled readonly class="form-control disabled" value="<?php echo e($to->name); ?>">
                                <input type="hidden" name="to_country_h[]" value="<?php echo e($to->id); ?>">
                            </div>
    
                            <?php if( $is_def_mile_or_fees == '1'): ?>
                                <div class="form-group col-md-3">
                                    <label><?php echo e(__('cargo::view.mile_cost')); ?>:</label>
                                    <input type="number" onchange="changeShippingCosts(this)" min="0" id="name" class="form-control" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php if(isset($default_country_cost->mile_cost)){echo ($default_country_cost->mile_cost);}else{ echo 0;} ?>" name="mile_cost[]">
                                </div>
                            <?php elseif($is_def_mile_or_fees == '2' ): ?>
                                <div class="form-group col-md-3">
                                    <label><?php echo e(__('cargo::view.shipping_cost')); ?>:</label>
                                    <input type="number" onchange="changeShippingCosts(this)" min="0" id="name" class="form-control" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php if(isset($default_country_cost->shipping_cost)){echo ($default_country_cost->shipping_cost);}else{ echo 0;} ?>" name="shipping_cost[]">
                                </div>
                            <?php endif; ?>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('cargo::view.tax')); ?>%:</label>
                                <input type="number" onchange="changeTax(this)" min="0" id="name" class="form-control" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php if(isset($default_country_cost->tax)){echo $default_country_cost->tax;}else{ echo 0;} ?>" name="tax[]">
                            </div>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('cargo::view.insurance')); ?>:</label>
                                <input type="number" onchange="changeInsurance(this)" min="0" id="name" class="form-control" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php if(isset($default_country_cost->insurance)){echo ($default_country_cost->insurance);}else{ echo 0;} ?>" name="insurance[]">
                            </div>
    
                            <?php if( $is_def_mile_or_fees == '1'): ?>
                                <div class="form-group col-md-3">
                                    <label><?php echo e(__('cargo::view.returned_mile_cost')); ?>:</label>
                                    <input type="number" onchange="changeReturnCosts(this)" min="0" id="name" class="form-control" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php if(isset($default_country_cost->return_mile_cost)){echo ($default_country_cost->return_mile_cost);}else{ echo 0;} ?>" name="return_mile_cost[]">
                                </div>
                            <?php elseif($is_def_mile_or_fees == '2' ): ?>
                                <div class="form-group col-md-3">
                                    <label><?php echo e(__('cargo::view.returned_shipmen_cost')); ?>:</label>
                                    <input type="number" onchange="changeReturnCosts(this)" min="0" id="name" class="form-control" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php if(isset($default_country_cost->return_cost)){echo ($default_country_cost->return_cost);}else{ echo 0;} ?>" name="return_cost[]">
                                </div>
                            <?php endif; ?>
                        </div>
                        <hr>
                        
                    </div>
    
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-12">
                    <div id="placeholder_cost">
                        <?php if(isset($from_region) && isset($to_region) ): ?>
                            <div class="card-header">
                                <h5 class="mb-0 h6"><?php echo e(__('cargo::view.from')); ?>: ( <?php echo e($from_region->name); ?> ) | <?php echo e(__('cargo::view.to')); ?>: ( <?php echo e($to_region->name); ?> )</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="row">
                                            <div class="form-group col-md-6">
                                                <label><?php echo e(__('cargo::view.from_region')); ?>:</label>
                                                <input disabled readonly class="form-control disabled" value="<?php echo e($from_region->name); ?>">
                                                <input type="hidden" name="from_state[]" value="<?php echo e($from_region->id); ?>">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label><?php echo e(__('cargo::view.to_region')); ?>:</label>
                                                <input disabled readonly class="form-control disabled" value="<?php echo e($to_region->name); ?>">
                                                <input type="hidden" name="to_state[]" value="<?php echo e($to_region->id); ?>">
                                            </div>

                                            <?php if( $is_def_mile_or_fees == '1'): ?>
                                                <div class="form-group col-md-3">
                                                    <label><?php echo e(__('cargo::view.mile_cost')); ?>:</label>
                                                    <input type="number" onchange="changeShippingCosts(this,<?php echo e($from_region->id); ?>)" min="0"  class="form-control shipp_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($region_cost->mile_cost ?? 0); ?>" name="state_mile_cost[]">
                                                </div>
                                            <?php elseif($is_def_mile_or_fees == '2' ): ?>
                                                <div class="form-group col-md-3">
                                                    <label><?php echo e(__('cargo::view.shipping_cost')); ?>:</label>
                                                    <input type="number" onchange="changeShippingCosts(this,<?php echo e($from_region->id); ?>)" min="0"  class="form-control shipp_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($region_cost->shipping_cost ?? 0); ?>" name="state_shipping_cost[]">
                                                </div>
                                            <?php endif; ?>
                                            <div class="form-group col-md-3">
                                                <label><?php echo e(__('cargo::view.tax')); ?>%:</label>
                                                <input type="number" onchange="changeTax(this,<?php echo e($from_region->id); ?>)" min="0"  class="form-control tax_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($region_cost->tax ?? 0); ?>" name="state_tax[]">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label><?php echo e(__('cargo::view.insurance')); ?>:</label>
                                                <input type="number" onchange="changeInsurance(this,<?php echo e($from_region->id); ?>)" min="0"  class="form-control insurance_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($region_cost->insurance ?? 0); ?>" name="state_insurance[]">
                                            </div>

                                            <?php if( $is_def_mile_or_fees == '1'): ?>
                                                <div class="form-group col-md-3">
                                                    <label><?php echo e(__('cargo::view.returned_mile_cost')); ?>:</label>
                                                    <input type="number" onchange="changeReturnCosts(this,<?php echo e($from_region->id); ?>)" min="0"  class="form-control return_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($region_cost->return_mile_cost ?? 0); ?>" name="state_return_mile_cost[]">
                                                </div>
                                            <?php elseif($is_def_mile_or_fees == '2' ): ?>
                                                <div class="form-group col-md-3">
                                                    <label><?php echo e(__('cargo::view.returned_shipmen_cost')); ?>:</label>
                                                    <input type="number" onchange="changeReturnCosts(this,<?php echo e($from_region->id); ?>)" min="0"  class="form-control return_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($region_cost->return_cost ?? 0); ?>" name="state_return_cost[]">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <hr>

                                    </div>

                                </div>
                            </div>
                            <hr>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <?php $__currentLoopData = $from_areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $to_areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $to_area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $area_cost = $area_costs->where('from_area_id', $area->id)->where('to_area_id', $to_area->id)->first();
                                                ?>
                                                <div class="row">
                                                    <div class="form-group col-md-6">
                                                        <label><?php echo e(__('cargo::view.from_area')); ?>:</label>
                                                        <input disabled readonly class="form-control disabled" value="<?php echo e(json_decode($area->name, true)[app()->getLocale()]); ?>">
                                                        <input type="hidden" name="from_area[]" value="<?php echo e($area->id); ?>">
                                                    </div>
                                                    <div class="form-group col-md-6">
                                                        <label><?php echo e(__('cargo::view.to_area')); ?>:</label>
                                                        <input disabled readonly class="form-control disabled" value="<?php echo e(json_decode($to_area->name, true)[app()->getLocale()]); ?>">
                                                        <input type="hidden" name="to_area[]" value="<?php echo e($to_area->id); ?>">
                                                    </div>
                                                    <div class="form-group col-md-3">
                                                        <label><?php if($is_def_mile_or_fees =='2'): ?> <?php echo e(__('cargo::view.shipping_cost')); ?> <?php else: ?> <?php echo e(__('cargo::view.mile_cost')); ?> <?php endif; ?>:</label>
                                                        <input type="number" min="0" id="name" class="form-control shipp_cost shipp_cost<?php echo e($from_region->id); ?>" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($area_cost->shipping_cost ?? 0); ?>" <?php if($is_def_mile_or_fees =='2'): ?> name="shipping_cost[]" <?php else: ?> name="mile_cost[]" <?php endif; ?>>
                                                    </div>
                                                    <div class="form-group col-md-3">
                                                        <label><?php echo e(__('cargo::view.tax')); ?>%:</label>
                                                        <input type="number" min="0" id="name" class="form-control tax_cost tax_cost<?php echo e($from_region->id); ?>" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($area_cost->tax ?? 0); ?>" name="tax[]">
                                                    </div>
                                                    <div class="form-group col-md-3">
                                                        <label><?php echo e(__('cargo::view.insurance')); ?>:</label>
                                                        <input type="number" min="0" id="name" class="form-control insurance_cost<?php echo e($from_region->id); ?> insurance_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($area_cost->insurance ?? 0); ?>" name="insurance[]">
                                                    </div>
                                                    <div class="form-group col-md-3">
                                                        <label><?php if($is_def_mile_or_fees =='2'): ?> <?php echo e(__('cargo::view.return_cost')); ?> <?php else: ?> <?php echo e(__('cargo::view.returned_mile_cost')); ?> <?php endif; ?>:</label>
                                                        <input type="number" min="0" id="name" class="form-control return_cost<?php echo e($from_region->id); ?> return_cost" placeholder="<?php echo e(__('cargo::view.here')); ?>" value="<?php echo e($area_cost->return_cost ?? 0); ?>" <?php if($is_def_mile_or_fees =='2'): ?> name="return_cost[]" <?php else: ?> name="return_mile_cost[]" <?php endif; ?>>
                                                    </div>
                                                </div>
                                                <hr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>


                        <?php endif; ?>
                    </div>

                </div>

            </div>


            <div class="card-footer">
                <div class="row">
                    <div class="col-lg-5"></div>
                    <div class="col-lg-7">
                        <button type="submit" class="evenAjaxButton btn btn-lg btn-primary"><?php echo e(__('cargo::view.save')); ?></button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <style>
        label {
            font-weight: bold !important;
        }
        .card-header{
            display: flex !important;
            align-items: center !important;
        }
        .form-control {
            margin-bottom: 15px !important;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        var inputs = document.getElementsByTagName('input');

        for (var i = 0; i < inputs.length; i++) {
            if (inputs[i].type.toLowerCase() == 'number') {
                inputs[i].onkeydown = function(e) {
                    if (!((e.keyCode > 95 && e.keyCode < 106) ||
                            (e.keyCode > 47 && e.keyCode < 58) ||
                            e.keyCode == 8)) {
                        return false;
                    }
                }
            }
        }
        function changeShippingCosts(element, id = null)
        {
            if(id){
                $('.shipp_cost'+id).val($(element).val());
            }else{
                $('.shipp_cost').val($(element).val());
            }
        }
        function changeTax(element, id = null)
        {
            if(id){
                $('.tax_cost'+id).val($(element).val());
            }else{
                $('.tax_cost').val($(element).val());
            }
        }
        function changeInsurance(element, id = null)
        {
            if(id){
                $('.insurance_cost'+id).val($(element).val());
            }else{
                $('.insurance_cost').val($(element).val());
            }
        }
        function changeReturnCosts(element, id = null)
        {
            if(id){
                $('.return_cost'+id).val($(element).val());
            }else{
                $('.return_cost').val($(element).val());
            }
        }
        $('.select-country').select2({
            placeholder: "Select Region"
        });
        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Modules/Cargo\Resources/views/adminLte/pages/countries/costs-repeter.blade.php ENDPATH**/ ?>