<?php echo csrf_field(); ?>

<!--begin::row -->
<div class="row mb-6">


    <!--begin::col -- title and content -->
    <div class="col-xl-8">


        <!--begin:: post content -->
        <div class="mb-6">
            <div class="card border">
                <!--begin::Card title-->
                <div class="card-title mx-4 mt-5">
                    <h4 class="fw-bolder"><?php echo e(__('blog::view.posts_table.post_content_section')); ?></h4>
                </div>
                <!--end::Card title-->
                <div class="card-body py-4">

                    <!--begin::Input group -- title -->
                    <div class="row mb-6">
                        <!--begin::Label-->
                        <label class="col-lg-3 col-form-label required fw-bold fs-6"><?php echo e(__('blog::view.posts_table.title')); ?></label>
                        <!--end::Label-->

                        <!--begin::Input group-->
                        <div class="col-lg-9">
                            <div class="mb-4">

                                <div class="input-group lang_container">
                                    <select class="change_language form-control form-control-sm badge badge-light fw-bold py-4 px-3 mw-100px">
                                        <option value="<?php echo e(get_current_lang()['code']); ?>" data-flag="<?php echo e(get_current_lang()['icon']); ?>" selected>
                                            <?php echo e(get_current_lang()['name']); ?>

                                        </option>
                                        <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($locale['code']); ?>" data-flag="<?php echo e($locale['icon']); ?>">
                                                <?php echo e($locale['name']); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <input
                                        type="text"
                                        name="title[<?php echo e(get_current_lang()['code']); ?>]"
                                        placeholder="<?php echo e(__('blog::view.posts_table.title')); ?>"
                                        value="<?php echo e(old('title.' . get_current_lang()['code'] , isset($model) ? $model->title : '')); ?>"
                                        class="form-control  form-control-multilingual form-control-<?php echo e(app()->getLocale()); ?>  <?php $__errorArgs = ['title.' . app()->getLocale()];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-slug-content="posts"
                                        data-model="post_title"
                                        data-model-limit="100"
                                    >
                                    <?php $__errorArgs = ['title.' . get_current_lang()['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <input
                                            type="text"
                                            class="form-control  form-control-multilingual form-control-<?php echo e($locale['code']); ?> <?php $__errorArgs = ['title.' . $locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> d-none"
                                            name="title[<?php echo e($locale['code']); ?>]"
                                            placeholder="<?php echo e(__('blog::view.posts_table.title')); ?>"
                                            value="<?php echo e(old('title.' . $locale['code'], isset($model) ? $model->getTranslation('title', $locale['code']) : '')); ?>"
                                        >

                                        <?php $__errorArgs = ['title.' . $locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <!--end::Input group-->
                    </div>
                    <!--end::Input group-->



                    <!--begin::Input group -- slug -->
                    <div class="row mb-6">
                        <!--begin::Label-->
                        <label class="col-lg-3 col-form-label required fw-bold fs-6"><?php echo e(__('blog::view.posts_table.slug')); ?></label>
                        <!--end::Label-->

                        <!--begin::Input group-->
                        <div class="col-lg-9">
                            <div class="mb-4">
                                <input
                                    type="text"
                                    name="slug"
                                    class="form-control form-control-sm <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php echo e($typeForm == 'edit' ? 'edited' : ''); ?>"
                                    placeholder="<?php echo e(__('blog::view.posts_table.slug')); ?>"
                                    value="<?php echo e(old('slug', isset($model) ? $model->slug : '')); ?>"
                                    data-slug-inject="posts"
                                >
                                <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <!--end::Input group-->
                    </div>
                    <!--end::Input group-->



                    <!--begin::Input group -- content -->
                    <div class="row mb-6">
                        <!--begin::Label-->
                        <label class="col-lg-3 col-form-label fw-bold fs-6"><?php echo e(__('blog::view.posts_table.content')); ?></label>
                        <!--end::Label-->

                        <!--begin::Input group-->
                        <div class="col-lg-9">

                            <div class="mb-4 lang_container text editor">
                                <select class="change_language form-control form-control-sm badge badge-light fw-bold py-4 px-3 ">
                                    <option value="<?php echo e(get_current_lang()['code']); ?>" data-flag="<?php echo e(get_current_lang()['icon']); ?>" selected>
                                        <?php echo e(get_current_lang()['name']); ?>

                                    </option>
                                    <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($locale['code']); ?>" data-flag="<?php echo e($locale['icon']); ?>">
                                            <?php echo e($locale['name']); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <div class="editor_container" id="editor_container_<?php echo e(get_current_lang()['code']); ?>">
                                    <input class="content_<?php echo e(get_current_lang()['code']); ?>_value" name="content[<?php echo e(get_current_lang()['code']); ?>]" type="hidden" value="<?php echo e(old('content.'.get_current_lang()['code'], isset($model) ? isset($model->content[get_current_lang()['code']]) ? $model->content[get_current_lang()['code']] : $model->content : '')); ?>">
                                    <div id="editor_content_<?php echo e(get_current_lang()['code']); ?>" class="editor_content_quillj <?php $__errorArgs = ['content.'.get_current_lang()['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo old('content.'.get_current_lang()['code'], isset($model) ? isset($model->content[get_current_lang()['code']]) ? $model->content[get_current_lang()['code']] : $model->content : ''); ?></div>
                                    <?php $__errorArgs = ['content.' . get_current_lang()['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="editor_container d-none" id="editor_container_<?php echo e($locale['code']); ?>">
                                        <input class="content_<?php echo e($locale['code']); ?>_value" name="content[<?php echo e($locale['code']); ?>]" type="hidden" value="<?php echo e(old('content.'.$locale['code'], isset($model) ? $model->getTranslation('content', $locale['code'])  : '')); ?>">
                                        <div id="editor_content_<?php echo e($locale['code']); ?>" class="editor_content_quillj <?php $__errorArgs = ['content.'.$locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo old('content.'.$locale['code'], isset($model) ? $model->getTranslation('content', $locale['code']) : ''); ?></div>
                                        <?php $__errorArgs = ['content.' . $locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                        <!--end::Input group-->
                    </div>
                    <!--end::Input group-->



                </div>

            </div>
        </div>
        <!--end:: post content -->

        <!--begin:: seo section -->
        <div class="mb-6">
            <div class="card border">
                <!--begin::Card title-->
                <div class="card-title mx-4 mt-5">
                    <h4 class="fw-bolder"><?php echo e(__('blog::view.posts_table.seo')); ?></h4>
                </div>
                <!--end::Card title-->
                <div class="card-body py-4">

                    <!--begin::Input group -- seo_title -->
                    <div class="row mb-6">
                        <!--begin::Label-->
                        <label class="col-lg-3 col-form-label fw-bold fs-6"><?php echo e(__('blog::view.posts_table.seo_title')); ?></label>
                        <!--end::Label-->

                        <!--begin::Input group-->
                        <div class="col-lg-9">


                            <div class="input-group lang_container">
                                <select class="change_language form-control form-control-sm badge badge-light fw-bold py-4 px-3 mw-100px">
                                    <option value="<?php echo e(get_current_lang()['code']); ?>" data-flag="<?php echo e(get_current_lang()['icon']); ?>" selected>
                                        <?php echo e(get_current_lang()['name']); ?>

                                    </option>
                                    <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($locale['code']); ?>" data-flag="<?php echo e($locale['icon']); ?>">
                                            <?php echo e($locale['name']); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input
                                    type="text"
                                    name="seo_title[<?php echo e(get_current_lang()['code']); ?>]"
                                    data-slug-content="categories"
                                    placeholder="<?php echo e(__('blog::view.posts_table.seo_title')); ?>"
                                    value="<?php echo e(old('seo_title.' . get_current_lang()['code'] , isset($model) ? $model->seo_title : '')); ?>"
                                    class="form-control  form-control-multilingual form-control-<?php echo e(app()->getLocale()); ?>  <?php $__errorArgs = ['seo_title.' . app()->getLocale()];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                >
                                <?php $__errorArgs = ['seo_title.' . get_current_lang()['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <input
                                        type="text"
                                        class="form-control  form-control-multilingual form-control-<?php echo e($locale['code']); ?> <?php $__errorArgs = ['seo_title.' . $locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> d-none"
                                        name="seo_title[<?php echo e($locale['code']); ?>]"
                                        placeholder="<?php echo e(__('blog::view.posts_table.seo_title')); ?>"
                                        value="<?php echo e(old('seo_title.' . $locale['code'], isset($model) ? $model->getTranslation('seo_title', $locale['code']) : '')); ?>"
                                    >

                                    <?php $__errorArgs = ['seo_title.' . $locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <!--end::Input group-->
                    </div>
                    <!--end::Input group-->



                    <!--begin::Input group -- seo_description -->
                    <div class="row mb-6">
                        <!--begin::Label-->
                        <label class="col-lg-3 col-form-label fw-bold fs-6"><?php echo e(__('blog::view.posts_table.seo_description')); ?></label>
                        <!--end::Label-->

                        <!--begin::Input group-->
                        <div class="col-lg-9">


                            <div class="mb-٤ lang_container text">
                                <select class="change_language form-control form-control-sm badge badge-light fw-bold py-4 px-3 ">
                                    <option value="<?php echo e(get_current_lang()['code']); ?>" data-flag="<?php echo e(get_current_lang()['icon']); ?>" selected>
                                        <?php echo e(get_current_lang()['name']); ?>

                                    </option>
                                    <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($locale['code']); ?>" data-flag="<?php echo e($locale['icon']); ?>">
                                            <?php echo e($locale['name']); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <textarea
                                    name="seo_description[<?php echo e(get_current_lang()['code']); ?>]"
                                    data-model-inject="post_desc_<?php echo e(get_current_lang()['code']); ?>"
                                    class="form-control  form-control-multilingual form-control-<?php echo e(get_current_lang()['code']); ?> <?php $__errorArgs = ['seo_description.' . get_current_lang()['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                ><?php echo e(old('seo_description.' . get_current_lang()['code'], isset($model) ? $model->seo_description : '')); ?></textarea>
                                <?php $__errorArgs = ['seo_description.' . get_current_lang()['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <textarea
                                        name="seo_description[<?php echo e($locale['code']); ?>]"
                                        data-model-inject="post_desc_<?php echo e($locale['code']); ?>"
                                        class="form-control form-control-multilingual form-control-<?php echo e($locale['code']); ?> d-none  <?php $__errorArgs = ['seo_description.' . $locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    ><?php echo e(old('seo_description.' . $locale['code'], isset($model) ? $model->getTranslation('seo_description', $locale['code']) : '')); ?></textarea>
                                    <?php $__errorArgs = ['seo_description.' . $locale['code']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                        <!--end::Input group-->
                    </div>
                    <!--end::Input group-->

                </div>
            </div>
        </div>
        <!--end:: seo section -->


    </div>
    <!--end::col -- title and content -->


    <!--begin::col -- publish, tags and categories -->
    <div class="col-xl-4">



        <!--begin:: Featured image -->
        <div class="card border mb-6">
            <!--begin::Card title-->
            <div class="card-title mx-4 mt-5">
                <h4 class="fw-bolder"><?php echo e(__('blog::view.posts_table.image')); ?></h4>
            </div>
            <!--end::Card title-->
            <div class="card-body py-4">

                <!--begin::Input group -- Select categories -->
                <div class="mb-6">
                    <?php if(isset($model)): ?>
                        <?php if (isset($component)) { $__componentOriginalc6729221c9417402b5667958f1a1bdf999245638 = $component; } ?>
<?php $component = $__env->getContainer()->make(Spatie\MediaLibraryPro\Http\Components\MediaLibraryCollectionComponent::class, ['maxItems' => '1','name' => 'image','model' => $model,'collection' => 'featured_image','rules' => 'mimes:jpg,jpeg,png,gif,bmp,svg,webp']); ?>
<?php $component->withName('media-library-collection'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc6729221c9417402b5667958f1a1bdf999245638)): ?>
<?php $component = $__componentOriginalc6729221c9417402b5667958f1a1bdf999245638; ?>
<?php unset($__componentOriginalc6729221c9417402b5667958f1a1bdf999245638); ?>
<?php endif; ?>
                    <?php else: ?>
                        <?php if (isset($component)) { $__componentOriginalcae27a4e6e39caf607462ff260282689f8dd9096 = $component; } ?>
<?php $component = $__env->getContainer()->make(Spatie\MediaLibraryPro\Http\Components\MediaLibraryAttachmentComponent::class, ['name' => 'image','rules' => 'mimes:jpg,jpeg,png,gif,bmp,svg,webp']); ?>
<?php $component->withName('media-library-attachment'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcae27a4e6e39caf607462ff260282689f8dd9096)): ?>
<?php $component = $__componentOriginalcae27a4e6e39caf607462ff260282689f8dd9096; ?>
<?php unset($__componentOriginalcae27a4e6e39caf607462ff260282689f8dd9096); ?>
<?php endif; ?>
                    <?php endif; ?>
                </div>
                <!--end::Input group-->

            </div>
        </div>
        <!--end:: Featured image -->



        <!--begin:: Categories -->
        <div class="card border mb-6">
            <!--begin::Card title-->
            <div class="card-title mx-4 mt-5">
                <h4 class="fw-bolder"><?php echo e(__('blog::view.categories')); ?></h4>
            </div>
            <!--end::Card title-->
            <div class="card-body py-4">

                <!--begin::Input group -- Select categories -->
                <div class="mb-6">
                    <!--begin::Label-->
                    <label class="mb-3 fw-bold fs-6" for="select_categories"><?php echo e(__('blog::view.select_categories')); ?></label>
                    <!--end::Label-->

                    <!--begin::Input group-->
                    <div class="input-content">

                        <select
                            class="form-control select_categories"
                            name="categories[]"
                            multiple
                            id="select_categories"
                            data-placeholder="<?php echo e(__('blog::view.categories_table.choose_category')); ?>"
                        >
                            <?php if($typeForm == 'edit'): ?>
                                <?php $__currentLoopData = $model->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>

                    </div>
                    <!--end::Input group-->
                </div>
                <!--end::Input group-->




                <!--begin::add new category -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create-categories')): ?>
                    <div class="mb-6">
                        <div class="button-add-new mb-4">
                            <button class="btn btn-sm btn-light-primary btn-show-form-new-category" type="button">
                                <i class="fas fa-plus fa-fw mx-1"></i>
                                <?php echo e(__('blog::view.add_new_category')); ?>

                            </button>
                        </div>

                        <div class="form-new-category border p-4" style="display: none;">

                            <!--begin:: category name -->
                            <div class="mb-4">
                                <!--begin::Label-->
                                <label class="mb-3 fw-bold fs-7 required"><?php echo e(__('blog::view.categories_table.name')); ?></label>
                                <!--end::Label-->

                                <!--begin::Input group-->
                                <div class="input-content">
                                    <input
                                        type="text"
                                        class="form-control form-control-sm form-new-category__name"
                                        placeholder="<?php echo e(__('blog::view.categories_table.name')); ?>"
                                    >
                                    <div class="invalid-feedback"></div>
                                </div>
                                <!--end::Input group-->
                            </div>
                            <!--end:: category name -->

                            <!--begin:: category parent_id -->
                            <div class="mb-4">
                                <!--begin::Label-->
                                <label class="mb-3 fw-bold fs-7" for="parent_category"><?php echo e(__('blog::view.categories_table.parent_category')); ?></label>
                                <!--end::Label-->

                                <!--begin::Input group-->
                                <div class="input-content">
                                    <select
                                        class="form-control select_categories form-new-category__parent_id"
                                        id="parent_category"
                                        data-placeholder="<?php echo e(__('blog::view.categories_table.choose_category')); ?>"
                                        data-allow-clear="true"
                                    >
                                    </select>
                                </div>
                                <!--end::Input group-->
                            </div>
                            <!--end:: category name -->

                            <!--begin:: btn create category -->
                            <div class="mb-4 d-flex justify-content-end ">
                                <button class="btn btn-sm btn-primary form-new-category__submit" type="button">
                                    <?php echo e(__('blog::view.add_category')); ?>

                                </button>
                            </div>
                            <!--end:: btn create category -->


                        </div>
                    </div>
                <?php endif; ?>
                <!--end::add new category -->

            </div>
        </div>
        <!--end:: Categories -->


        <!--begin:: tags -->
        <div class="card border mb-6">
            <!--begin::Card title-->
            <div class="card-title mx-4 mt-5">
                <h4 class="fw-bolder"><?php echo e(__('blog::view.tags')); ?></h4>
            </div>
            <!--end::Card title-->
            <div class="card-body py-4">

                <!--begin::Input group -- Select tags -->
                <div class="mb-6">
                    <!--begin::Label-->
                    <label class="mb-3 fw-bold fs-6" for="select_tags"><?php echo e(__('blog::view.select_tags')); ?></label>
                    <!--end::Label-->

                    <!--begin::Input group-->
                    <div class="input-content">
                        <select
                            class="form-control"
                            name="tags[]"
                            id="select_tags"
                            data-placeholder="<?php echo e(__('blog::view.tags_table.choose_tags_or_add_new')); ?>"
                        >
                            <?php if($typeForm == 'edit'): ?>
                                <?php $__currentLoopData = $model->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tag->id); ?>"><?php echo e($tag->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>

                    </div>
                    <!--end::Input group-->
                </div>
                <!--end::Input group-->

            </div>
        </div>
        <!--end:: tags -->


        <!--begin:: Publish -->
        <div class="card border mb-6">
            <!--begin::Card title-->
            <div class="card-title mx-4 mt-5">
                <h4 class="fw-bolder"><?php echo app('translator')->get('view.publish'); ?></h4>
            </div>
            <!--end::Card title-->
            <div class="card-body py-4">

                <!--begin::Input group -- publish status -->
                <?php if($typeForm == 'edit' && $model->published): ?>
                    <div class="mb-6">
                        <!--begin::Label-->
                        <label class="mb-3 fw-bold fs-6"><?php echo e(__('view.status')); ?></label>
                        <!--end::Label-->

                        <!--begin::Input group-->
                        <div class="input-content">
                            <div class="custom-control custom-switch form-check form-switch">
                                <input
                                    class="custom-control-input "
                                    name="published"
                                    type="checkbox"
                                    id="post_published"
                                    value="1"
                                    <?php echo e(old('published', $model->published) == 1 ? 'checked="checked"' : ''); ?>

                                >
                                <label
                                    class="custom-control-label"
                                    for="post_published"
                                >
                                    <?php echo e(__('view.published')); ?>

                                </label>
                            </div>
                        </div>
                        <!--end::Input group-->
                    </div>
                <?php endif; ?>
                <!--end::Input group-->



                <!--begin::Input group -- publish status -->
                <div class="mb-6">
                    <!--begin::Label-->
                    <label class="mb-3 fw-bold fs-6"><?php echo e(__('blog::view.posts_table.visibility')); ?></label>
                    <!--end::Label-->

                    <!--begin::Input group-->
                    <div class="input-content d-flex">
                        <div class="form-check mx-1">
                            <input
                                class=""
                                name="visibility"
                                type="radio"
                                id="post_visibility_public"
                                value="public"
                                <?php echo e(isset($model) ? (old('visibility', $model->visibility) == 'public' ? 'checked="checked"' : '') : 'checked="checked"'); ?>

                            >
                            <label
                                class="form-check-label"
                                for="post_visibility_public"
                            >
                                <?php echo e(__('blog::view.posts_table.public')); ?>

                            </label>
                        </div>
                        <div class="form-check mx-1">
                            <input
                                class=""
                                name="visibility"
                                type="radio"
                                id="post_visibility_auth_user"
                                value="auth_user"
                                <?php echo e(isset($model) ? (old('visibility', $model->visibility) == 'auth_user' ? 'checked="checked"' : '') : old('visibility')); ?>

                            >
                            <label
                                class="form-check-label"
                                for="post_visibility_auth_user"
                            >
                                <?php echo e(__('blog::view.posts_table.auth_user')); ?>

                            </label>
                        </div>
                    </div>
                    <!--end::Input group-->
                </div>
                <!--end::Input group-->



                <!--begin::Input group -- publish immediately -->
                <div class="mb-6">
                    <!--begin::Label-->
                    <label class="mb-3 fw-bold fs-6" for="post_publish_immediately"><?php echo e(__('view.publish_immediately')); ?></label>
                    <!--end::Label-->

                    <!--begin::Input group-->
                    <div class="input-content">
                        <input
                            class="form-control mw-250px <?php $__errorArgs = ['publish_on'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            placeholder="<?php echo e(__('view.pick_date_range')); ?>"
                            id="post_publish_immediately"
                            value="<?php echo e(isset($model) && old('publish_on', $model->publish_on) != null ? (
                                date('Y-m-d', strtotime(old('publish_on', $model->publish_on))) . ' At ' . date('h:i A', strtotime(old('publish_on', $model->publish_on)))
                                ) : (
                                old('publish_on') != null ? (date('Y-m-d', strtotime(old('publish_on'))) . ' At ' . date('h:i A', strtotime(old('publish_on')))
                                ) : '')); ?>"
                        >
                        <?php $__errorArgs = ['publish_on'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <input
                            type="hidden"
                            name="publish_on"
                            id="post_publish_immediately_value"
                            value=""
                        >
                    </div>
                    <!--end::Input group-->
                </div>
                <!--end::Input group-->




                <!--begin::Input group -- activations -->
                <?php if($typeForm == 'edit'): ?>
                    <div class="mb-6">
                        <!--begin::Label-->
                        <label class="mb-3 fw-bold fs-6"><?php echo e(__('view.activation')); ?></label>
                        <!--end::Label-->

                        <!--begin::Input group-->
                        <div class="input-content">
                            <div class="custom-control custom-switch form-check form-switch">
                                <input
                                    class="custom-control-input "
                                    name="active"
                                    type="checkbox"
                                    id="category_activation"
                                    value="1"
                                    <?php echo e(old('active', isset($model) ? $model->active : true) == 1 ? 'checked="checked"' : ''); ?>

                                >
                                <label
                                    class="custom-control-label"
                                    for="category_activation"
                                >
                                    <?php echo e(__('view.active')); ?>

                                </label>
                            </div>
                        </div>
                        <!--end::Input group-->
                    </div>
                <?php endif; ?>
                <!--end::Input group-->
            </div>
        </div>
        <!--end:: Publish -->



    </div>
    <!--end::col -- tags and category -->

</div>
<!--end::row -->


<?php $__env->startPush('js-component'); ?>
    <script>
        // editor
        var toolbarOptions = [
            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
            [{ 'font': [] }],
            [{ 'align': [] }],
            [{ 'list': 'ordered'}, { 'list': 'bullet' }],
            [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
            [{ 'direction': 'rtl' }],                         // text direction
            ['link', 'image'],
            ['blockquote', 'code-block'],
            [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
            [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
            ['bold', 'italic', 'underline', 'strike', 'clean'],        // toggled buttons
        ];
        var options = {
            debug: 'info',
            modules: {
                toolbar: toolbarOptions
            },
            placeholder: "<?php echo e(__('blog::view.posts_table.post_content')); ?>",
            theme: 'snow', // snow, bubble
        };
        
        var editorEle = document.getElementById('editor_content_<?php echo e(get_current_lang()['code']); ?>');
        if (editorEle) {
            var editor = new Quill('#editor_content_<?php echo e(get_current_lang()['code']); ?>', options),
            qlEditor = $(editorEle).children('.ql-editor');
            editor.on('editor-change', function() {
                var getHTML = qlEditor.html().trim(),
                    getText_<?php echo e(get_current_lang()['code']); ?> = editor.getText().trim(),
                    seo_desc_<?php echo e(get_current_lang()['code']); ?> = $('[data-model-inject="post_desc_<?php echo e(get_current_lang()['code']); ?>"]');
                $('.content_<?php echo e(get_current_lang()['code']); ?>_value').val(getHTML);
                if (!seo_desc_<?php echo e(get_current_lang()['code']); ?>.hasClass('edited')) {
                    seo_desc_<?php echo e(get_current_lang()['code']); ?>.val(getText_<?php echo e(get_current_lang()['code']); ?>.substr(0, 150));
                }
            })
        }
        <?php $__currentLoopData = get_langauges_except_current(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            var editorEle = document.getElementById('editor_content_<?php echo e($locale['code']); ?>');
            if (editorEle) {
                var editor = new Quill('#editor_content_<?php echo e($locale['code']); ?>', options),
                qlEditor_<?php echo e($locale['code']); ?> = $(editorEle).children('.ql-editor');
                editor.on('editor-change', function() {
                    var getHTML = qlEditor_<?php echo e($locale['code']); ?>.html().trim(),
                        getText = editor.getText().trim(),
                        seo_desc_<?php echo e($locale['code']); ?> = $('[data-model-inject="post_desc_<?php echo e($locale['code']); ?>"]');
                    $('.content_<?php echo e($locale['code']); ?>_value').val(getHTML);
                    if (!seo_desc_<?php echo e($locale['code']); ?>.hasClass('edited')) {
                        seo_desc_<?php echo e($locale['code']); ?>.val(getText.substr(0, 150));
                    }
                })
            }
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        // end editor
        /*******************************************************************************************/


        // publish date
        var inputDate = $(`#post_publish_immediately`),
            inputDateValue = $('#post_publish_immediately_value'),
            start;
        // Trigger date picker for created at
        inputDate.daterangepicker({
            showDropdowns: true,
            singleDatePicker: true,
            autoUpdateInput: false,
            minYear: parseInt(moment().format('YYYY')) - 10,
            maxYear: parseInt(moment().format('YYYY')) + 10,
            timePicker: true,
            startDate: moment().startOf('minute'),
            // timePickerSeconds: false,
            locale: {
                format: "DD/MM/YYYY",
                cancelLabel: "<?php echo e(__('view.cancel')); ?>",
                applyLabel: "<?php echo e(__('view.apply')); ?>",
                "fromLabel": "<?php echo e(__('view.from')); ?>",
                "toLabel": "<?php echo e(__('view.to')); ?>",
                "customRangeLabel": "<?php echo e(__('datepicker.custom_range')); ?>",
                "weekLabel": "<?php echo e(__('datepicker.week_label')); ?>",
                "daysOfWeek": [
                    "<?php echo e(__('datepicker.days_of_week.sunday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.monday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.tuesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.wednesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.thursday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.friday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.saturday')); ?>",
                ],
                "monthNames": [
                    "<?php echo e(__('datepicker.month_names.january')); ?>",
                    "<?php echo e(__('datepicker.month_names.february')); ?>",
                    "<?php echo e(__('datepicker.month_names.march')); ?>",
                    "<?php echo e(__('datepicker.month_names.april')); ?>",
                    "<?php echo e(__('datepicker.month_names.may')); ?>",
                    "<?php echo e(__('datepicker.month_names.june')); ?>",
                    "<?php echo e(__('datepicker.month_names.july')); ?>",
                    "<?php echo e(__('datepicker.month_names.august')); ?>",
                    "<?php echo e(__('datepicker.month_names.september')); ?>",
                    "<?php echo e(__('datepicker.month_names.october')); ?>",
                    "<?php echo e(__('datepicker.month_names.november')); ?>",
                    "<?php echo e(__('datepicker.month_names.december')); ?>",
                ],
            }
        }, cb);
        // call back after choose date
        function cb(start) {
            var apiDate = start ? start.format("YYYY-MM-DD H:m") : '';
            var inputShowDate = start ? (start.format("YYYY-MM-DD") + ' At ' + start.format("h:m A")) : '';
            if (start) {
                inputDate.val(inputShowDate);
                inputDateValue.val(apiDate);
            }
        }
        cb(start);
        // end publish date
        /*******************************************************************************************/


        // select categories
        var selectCategories = $('.select_categories'),
            selectEditCategories = $('#select_categories');
        selectCategories.select2({
            closeOnSelect: false,
            ajax: {
                url: "<?php echo e(fr_route('categories.search')); ?>",
                dataType: 'json',
                delay: 500,
                data: function (params) {
                    return { search: params.term };
                },
                processResults: function (data) {
                    if (data && data.categories) {
                        return {
                            results: data.categories.map(function(category) {
                                return {id: category.id, text: category.name}
                            })
                        };
                    }
                },
                cache: true,
            },
        });
        <?php if($typeForm == 'edit'): ?>
            selectEditCategories.val([<?php echo e(implode(", ", $model->categories->pluck("id")->toArray())); ?>]).trigger('change');
        <?php endif; ?>
        // end select categories
        /*******************************************************************************************/


        // select tags
        var selectTags = $('#select_tags');
        selectTags.select2({
            multiple: true,
            closeOnSelect: false,
            tags: <?php echo auth()->user()->can('create-tags') ? 'true' : 'false'; ?>,
            tokenSeparators: [','],
            ajax: {
                url: "<?php echo e(fr_route('tags.search')); ?>",
                dataType: 'json',
                delay: 500,
                data: function (params) {
                    return { search: params.term };
                },
                processResults: function (data) {
                    if (data && data.tags) {
                        return {
                            results: data.tags.map(function(category) {
                                return {id: category.id, text: category.name}
                            })
                        };
                    }
                },
                cache: true,
            },
        });
        <?php if($typeForm == 'edit'): ?>
            selectTags.val([<?php echo e(implode(",", $model->tags->pluck("id")->toArray())); ?>]).trigger('change');
        <?php endif; ?>
        // end select tags
        /*******************************************************************************************/
        // add new category
        // show form
        var btnShowFormNewCategory = $('.btn-show-form-new-category'),
            formNewCategory = $('.form-new-category');
        btnShowFormNewCategory.on('click', function() {
            formNewCategory.slideToggle(200);
        });
        formNewCategory.find('.form-new-category__submit').on('click', function() {
            var name = $('.form-new-category__name'),
                parent_id = $('.form-new-category__parent_id'),
                url = '<?php echo e(route("categories.simple-create")); ?>',
                data = {name: name.val(), parent_id: parent_id.val()};

            Object.assign(data, {_token: _csrf_token});
            axios.post(url, data).then(res => {
                Toast.fire({
                    icon: 'success',
                    title: res.data.message ? res.data.message : `Category has been created successfully`
                });
                // update categories select
                var oldCurrentValue = selectEditCategories.val();
                if (res.data && res.data.category) {
                    var category = res.data.category;
                    oldCurrentValue.push(category.id)
                    var newOption = new Option(category.name, category.id, false, false);
                    selectEditCategories.append(newOption).trigger('change');
                    selectEditCategories.val(oldCurrentValue).trigger('change');
                }
                // reset form
                name.removeClass('is-invalid');
                name.val('');
                parent_id.val('');
            }).catch(error => {
                if (error.response.status == 422) {
                    var errorName = error.response.data.errors && error.response.data.errors.name ? error.response.data.errors.name[0] : null;
                    if (errorName) {
                        name.addClass('is-invalid');
                        name.next('.invalid-feedback').text(errorName);
                        Toast.fire({
                            icon: 'error',
                            title: error.response.data.message
                        });
                    } else {
                        Toast.fire({
                            icon: 'error',
                            title: 'Server error!'
                        });
                    }

                } else if (error.response.status == 500) {
                    Toast.fire({
                        icon: 'error',
                        title: 'Server error!'
                    });
                }
            })

        });
        /*******************************************************************************************/
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/elitedesigncom/courier.elitedesign.com.bd/Modules/Blog/Resources/views/adminLte/pages/posts/form.blade.php ENDPATH**/ ?>