<?php
$user_role = auth()->user()->role;
$admin = 1;
$staff = 0;
$branch = 3;
$client = 4;
$driver = 5;
?>


<?php if(auth()->user()->can('manage-shipments') || in_array($user_role, [$admin, $client, $branch])): ?>
    <li
        class="nav-item <?php echo e(areActiveRoutes(['shipments','shipments.create','shipments.import','shipments.add.api','shipments.barcode.scanner','shipment-calc','shipments.index'],'menu-is-opening menu-open active')); ?> <?php $__currentLoopData = Modules\Cargo\Entities\Shipment::status_info(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e(areActiveRoutes([$item['route_name']], 'menu-is-opening menu-open active')); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> ">
        <a href="#"
            class="nav-link <?php echo e(areActiveRoutes(['shipments','shipments.create','shipments.import','shipments.add.api','shipments.barcode.scanner','shipment-calc','shipments.index'],'menu-is-opening menu-open active')); ?> <?php $__currentLoopData = Modules\Cargo\Entities\Shipment::status_info(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e(areActiveRoutes([$item['route_name']], 'menu-is-opening menu-open active')); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>  ">
            <i class="fas fa-box-open"></i>
            <p>
                <?php echo e(__('cargo::view.shipments')); ?>

                <i class="right fas fa-angle-left"></i>
            </p>
        </a>

        <ul class="nav nav-treeview">
            <!-- Shipment Menu -->
            <?php if(auth()->user()->can('manage-shipments') || in_array($user_role, [$admin, $client, $branch])): ?>

                <!-- create shipment -->
                <?php if(auth()->user()->can('create-shipments') || in_array($user_role, [$admin, $client, $branch])): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(fr_route('shipments.create')); ?>"
                            class="nav-link <?php echo e(areActiveRoutes(['shipments.create'])); ?>">
                            <i class="fas fa-plus fa-fw"></i>
                            <p><?php echo e(__('cargo::view.create_new_shipment')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>



                <?php if(in_array($user_role, [$admin, $client, $branch]) || auth()->user()->can('import-shipments')): ?>
                    <!-- import shipment -->
                    <li class="nav-item">
                        <a href="<?php echo e(fr_route('shipments.import')); ?>"
                            class="nav-link <?php echo e(areActiveRoutes(['shipments.import'])); ?>">
                            <i class="fas fa-file-import fa-fw"></i>
                            <p><?php echo e(__('cargo::view.import_shipments')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if($user_role == $client): ?>
                    <!-- shipment api -->
                    <li class="nav-item">
                        <a href="<?php echo e(fr_route('shipments.add.api')); ?>"
                            class="nav-link <?php echo e(areActiveRoutes(['shipments.add.api'])); ?>">
                            <i class="fas fa-plus fa-fw"></i>
                            <p><?php echo e(__('cargo::view.shipment_apis')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- shipment barcode scanner -->
                <?php if(auth()->user()->can('shipments-barcode-scanner') || $user_role == $admin): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(fr_route('shipments.barcode.scanner')); ?>"
                            class="nav-link <?php echo e(areActiveRoutes(['shipments.barcode.scanner'])); ?>">
                            <i class="fas fa-qrcode fa-fw"></i>
                            <p><?php echo e(__('cargo::view.barcode_scanner')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- shipment calc -->
                <?php if(Modules\Cargo\Entities\ShipmentSetting::getVal('is_shipping_calc_required') == 1): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(fr_route('shipments.calculator')); ?>"
                            class="nav-link <?php echo e(areActiveRoutes(['shipments.calculator'])); ?>">
                            <i class="fas fa-calculator fa-fw"></i>
                            <p><?php echo e(__('cargo::view.shipping_calculator')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>

                <!-- all shipments -->
                <li class="nav-item">
                    <a href="<?php echo e(fr_route('shipments.index')); ?>"
                        class="nav-link <?php echo e(areActiveRoutes(['shipments.index'])); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p><?php echo e(__('cargo::view.all_Shipments')); ?></p>
                    </a>
                </li>


                <?php $__currentLoopData = Modules\Cargo\Entities\Shipment::status_info(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(in_array($user_role, [$admin, $client, $branch]) ||
    auth()->user()->hasAnyDirectPermission($item['permissions'])): ?>
                        <?php if($item['status'] == Modules\Cargo\Entities\Shipment::SAVED_STATUS): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route($item['route_name'], ['status' => $item['status'], 'type' => Modules\Cargo\Entities\Shipment::PICKUP])); ?>"
                                    class="nav-link <?php echo e(active_route($item['route_name'], ['status' => $item['status'],'type' => Modules\Cargo\Entities\Shipment::PICKUP])); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p><?php echo e(__('cargo::view.saved_pickup')); ?></p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route($item['route_name'], ['status' => $item['status'],'type' => Modules\Cargo\Entities\Shipment::DROPOFF])); ?>"
                                    class="nav-link <?php echo e(active_route($item['route_name'], ['status' => $item['status'],'type' => Modules\Cargo\Entities\Shipment::DROPOFF])); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p><?php echo e(__('cargo::view.saved_dropoff')); ?></p>
                                </a>
                            </li>
                        <?php elseif($item['status'] == Modules\Cargo\Entities\Shipment::REQUESTED_STATUS): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route($item['route_name'], ['status' => $item['status'], 'type' => Modules\Cargo\Entities\Shipment::PICKUP])); ?>"
                                    class="nav-link <?php echo e(active_route($item['route_name'], ['status' => $item['status'],'type' => Modules\Cargo\Entities\Shipment::PICKUP])); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p><?php echo e(__('cargo::view.requested_pickup')); ?></p>
                                </a>
                            </li>
                        <?php else: ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route($item['route_name'], ['status' => $item['status']])); ?>"
                                    class="nav-link <?php echo e(active_route($item['route_name'], ['status' => $item['status']])); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p><?php echo e($item['text']); ?></p>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php endif; ?>
        </ul>
    </li>
<?php endif; ?>


<?php if(auth()->user()->can('manage-missions') ||
    $user_role == $admin ||
    $user_role == $branch ||
    $user_role == $driver): ?>
    <li
        class="nav-item <?php echo e(active_uri('missions', ['class_name' => 'show'])); ?> <?php echo e(areActiveRoutes(['missions', 'missions.index'], 'menu-is-opening menu-open active')); ?>  <?php $__currentLoopData = Modules\Cargo\Entities\Mission::status_info(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e(areActiveRoutes([$item['route_name']], 'menu-is-opening menu-open active')); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">
        <a href="#"
            class="nav-link <?php echo e(active_uri('missions')); ?> <?php echo e(areActiveRoutes(['missions', 'missions.index'], 'menu-is-opening menu-open active')); ?>  <?php $__currentLoopData = Modules\Cargo\Entities\Mission::status_info(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e(areActiveRoutes([$item['route_name']], 'menu-is-opening menu-open active')); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">
            <i class="fas fa-shipping-fast"></i>
            <p>
                <?php echo e(__('cargo::view.missions')); ?>

                <i class="right fas fa-angle-left"></i>
            </p>
        </a>

        <ul class="nav nav-treeview">
            <!-- Mission Menu -->
            <?php if(auth()->user()->can('manage-missions') ||
    $user_role == $admin ||
    $user_role == $branch ||
    $user_role == $driver): ?>

                <li class="nav-item">
                    <a href="<?php echo e(fr_route('missions.index')); ?>"
                        class="nav-link <?php echo e(areActiveRoutes(['missions.index'])); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p><?php echo e(__('cargo::view.all_missions')); ?></p>
                    </a>
                </li>

                <?php $__currentLoopData = Modules\Cargo\Entities\Mission::status_info(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(in_array($user_role, $item['user_role']) ||
    auth()->user()->hasAnyDirectPermission($item['permissions'])): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route($item['route_name'], ['status' => $item['status']])); ?>"
                                class="nav-link <?php echo e(active_route($item['route_name'], ['status' => $item['status']])); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p><?php echo e($item['text']); ?></p>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php endif; ?>
        </ul>
    </li>
<?php endif; ?>


<?php if(auth()->user()->can('manage-manifests') || in_array($user_role, [$admin, $driver, $branch])): ?>
    <li class="nav-item   <?php echo e(areActiveRoutes(['missions.manifests'], 'menu-is-opening menu-open active')); ?>">
        <a href="<?php echo e(fr_route('missions.manifests')); ?>"
            class="nav-link <?php echo e(areActiveRoutes(['missions.manifests'])); ?>">
            <i class="fas fa-truck-moving fa-fw"></i>
            <p><?php echo e(__('cargo::view.manifest')); ?></p>
        </a>
    </li>
<?php endif; ?>


<?php if(auth()->user()->can('manage-transactions') || in_array($user_role, [$admin, $branch, $driver, $client])): ?>
    <li
        class="nav-item <?php echo e(active_uri('transactions', ['class_name' => 'show'])); ?>  <?php echo e(areActiveRoutes(['transactions', 'transactions.create', 'transactions.index'],'menu-is-opening menu-open active')); ?>">
        <a href="#"
            class="nav-link <?php echo e(active_uri('transactions')); ?>  <?php echo e(areActiveRoutes(['transactions', 'transactions.create', 'transactions.index'],'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-money-check-alt"></i>
            <p>
                <?php echo e(__('cargo::view.transactions')); ?>

                <i class="right fas fa-angle-left"></i>
            </p>
        </a>

        <ul class="nav nav-treeview">

            <!-- Transaction list -->
            <?php if(auth()->user()->can('manage-transactions') || in_array($user_role, [$admin, $branch, $driver, $client])): ?>
                <li class="nav-item">
                    <a href="<?php echo e(fr_route('transactions.index')); ?>"
                        class="nav-link <?php echo e(areActiveRoutes(['transactions.index'])); ?>">
                        <i class="fas fa-list fa-fw"></i>
                        <p><?php echo e(__('cargo::view.all_transactions')); ?></p>
                    </a>
                </li>
            <?php endif; ?>

            <!-- Create new transaction -->
            <?php if(auth()->user()->can('create-transactions') || in_array($user_role, [$admin, $branch])): ?>
                <li class="nav-item">
                    <a href="<?php echo e(fr_route('transactions.create')); ?>"
                        class="nav-link <?php echo e(areActiveRoutes(['transactions.create'])); ?>">
                        <i class="fas fa-plus fa-fw"></i>
                        <p><?php echo e(__('cargo::view.create_new_transaction')); ?></p>
                    </a>
                </li>
            <?php endif; ?>

        </ul>
    </li>
<?php endif; ?>



<?php if(auth()->user()->can('manage-branches') ||
    auth()->user()->can('manage-customers') ||
    auth()->user()->can('manage-drivers') ||
    $user_role == $admin ||
    $user_role == $branch): ?>
    <li
        class="nav-item <?php echo e(active_uri('shipment-team', ['class_name' => 'show'])); ?> <?php echo e(areActiveRoutes(['branches','branches.create','branches.index','branches','clients.index','clients.create','clients','drivers.index','drivers.create','drivers','shipment-team'],'menu-is-opening menu-open active')); ?>">
        <a href="#"
            class="nav-link <?php echo e(areActiveRoutes(['branches','branches.create','branches.index','branches','clients.index','clients.create','clients','drivers.index','drivers.create','drivers','shipment-team'],'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-users"></i>
            <p>
                <?php echo e(__('cargo::view.shipment_team')); ?>

                <i class="right fas fa-angle-left"></i>
            </p>
        </a>

        <ul class="nav nav-treeview">

            <!-- Branch Menu -->
            <?php if(auth()->user()->can('manage-branches') || $user_role == $admin): ?>
                <li
                    class="nav-item <?php echo e(active_uri('branches', ['class_name' => 'show'])); ?>     <?php echo e(areActiveRoutes(['branches.create', 'branches.index', 'branches'], 'menu-is-opening menu-open active')); ?>">
                    <a href="#"
                        class="nav-link <?php echo e(areActiveRoutes(['branches.create', 'branches.index', 'branches'], 'menu-is-opening menu-open active')); ?>">
                        <i class="fas fa-map-marked-alt"></i>
                        <p>
                            <?php echo e(__('cargo::view.branches')); ?>

                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview">

                        <!-- Branch list -->
                        <?php if(auth()->user()->can('view-branches') || $user_role == $admin): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(fr_route('branches.index')); ?>"
                                    class="nav-link <?php echo e(areActiveRoutes(['branches.index'])); ?>">
                                    <i class="fas fa-list fa-fw"></i>
                                    <p><?php echo e(__('cargo::view.branch_list')); ?></p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <!-- Create new branch -->
                        <?php if(auth()->user()->can('create-branches') || $user_role == $admin): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(fr_route('branches.create')); ?>"
                                    class="nav-link <?php echo e(areActiveRoutes(['branches.create'])); ?>">
                                    <i class="fas fa-plus fa-fw"></i>
                                    <p><?php echo e(__('cargo::view.create_new_branch')); ?></p>
                                </a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <!-- Customer Menu -->
            <?php if(auth()->user()->can('manage-customers') ||
    $user_role == $admin ||
    $user_role == $branch): ?>

                <li
                    class="nav-item <?php echo e(active_uri('clients', ['class_name' => 'show'])); ?> <?php echo e(areActiveRoutes(['clients.index', 'clients.create', 'clients'], 'menu-is-opening menu-open active')); ?>">
                    <a href="#"
                        class="nav-link <?php echo e(areActiveRoutes(['clients.index', 'clients.create', 'clients'], 'menu-is-opening menu-open active')); ?>">
                        <i class="fas fa-user-friends"></i>
                        <p>
                            <?php echo e(__('cargo::view.clients')); ?>

                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview">

                        <!-- Customers list -->
                        <?php if(auth()->user()->can('view-customers') ||
    $user_role == $admin ||
    $user_role == $branch): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(fr_route('clients.index')); ?>"
                                    class="nav-link <?php echo e(areActiveRoutes(['clients.index'])); ?>">
                                    <i class="fas fa-list fa-fw"></i>
                                    <p><?php echo e(__('cargo::view.client_list')); ?></p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <!-- Create new customer -->
                        <?php if(auth()->user()->can('create-customers') ||
    $user_role == $admin ||
    $user_role == $branch): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(fr_route('clients.create')); ?>"
                                    class="nav-link <?php echo e(areActiveRoutes(['clients.create'])); ?>">
                                    <i class="fas fa-plus fa-fw"></i>
                                    <p><?php echo e(__('cargo::view.create_new_client')); ?></p>
                                </a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <!-- Driver Menu -->
            <?php if(auth()->user()->can('manage-drivers') ||
    $user_role == $admin ||
    $user_role == $branch): ?>

                <li
                    class="nav-item <?php echo e(active_uri('drivers', ['class_name' => 'show'])); ?>  <?php echo e(areActiveRoutes(['drivers.index', 'drivers.create', 'drivers'], 'menu-is-opening menu-open active')); ?>">
                    <a href="#"
                        class="nav-link <?php echo e(areActiveRoutes(['drivers.index', 'drivers.create', 'drivers'], 'menu-is-opening menu-open active')); ?>">
                        <i class="fas fa-people-carry"></i>
                        <p>
                            <?php echo e(__('cargo::view.drivers')); ?>

                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <!-- Driver list -->
                        <?php if(auth()->user()->can('view-drivers') ||
    $user_role == $admin ||
    $user_role == $branch): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(fr_route('drivers.index')); ?>"
                                    class="nav-link <?php echo e(areActiveRoutes(['drivers.index'])); ?>">
                                    <i class="fas fa-list fa-fw"></i>
                                    <p><?php echo e(__('cargo::view.driver_list')); ?></p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <!-- Create new driver -->
                        <?php if(auth()->user()->can('create-drivers') ||
    $user_role == $admin ||
    $user_role == $branch): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(fr_route('drivers.create')); ?>"
                                    class="nav-link <?php echo e(areActiveRoutes(['drivers.create'])); ?>">
                                    <i class="fas fa-plus fa-fw"></i>
                                    <p><?php echo e(__('cargo::view.create_new_driver')); ?></p>
                                </a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

        </ul>
    </li>
<?php endif; ?>
<?php /**PATH /home/elitedesigncom/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/components/aside_menu.blade.php ENDPATH**/ ?>