<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-users')): ?>
    
    <li class="nav-item <?php echo e(areActiveRoutes(['users.index', 'users.create'], 'menu-is-opening menu-open active')); ?>">
        <a href="#"
            class="nav-link <?php echo e(areActiveRoutes(['users.index', 'users.create'], 'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-user"></i>
            <p>
                <?php echo e(__('users::view.users')); ?>

                <i class="right fas fa-angle-left"></i>
            </p>
        </a>

        <ul class="nav nav-treeview">

            <!-- Branch list -->
            <?php if(auth()->user()->can('view-users') || $user_role == $admin): ?>
                <li class="nav-item">
                    <a href="<?php echo e(fr_route('users.index')); ?>" class="nav-link <?php echo e(areActiveRoutes(['users.index'])); ?>">
                        <i class="fas fa-list fa-fw"></i>
                        <p><?php echo e(__('users::view.user_list')); ?></p>
                    </a>
                </li>
            <?php endif; ?>

            <!-- Create new branch -->
            <?php if(auth()->user()->can('create-users') || $user_role == $admin): ?>
                <li class="nav-item">
                    <a href="<?php echo e(fr_route('users.create')); ?>" class="nav-link <?php echo e(areActiveRoutes(['users.create'])); ?>">
                        <i class="fas fa-plus fa-fw"></i>
                        <p><?php echo e(__('users::view.create_new_user')); ?></p>
                    </a>
                </li>
            <?php endif; ?>

        </ul>
    </li>
<?php endif; ?>
<?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/Modules/Users/Resources/views/adminLte/components/aside_menu.blade.php ENDPATH**/ ?>