
<div class="d-flex justify-content-end align-items-center d-none" id="<?php echo e($table_id); ?>_selected_component">

    <div class="fw-bolder me-5"><span class="me-2 selected-count">0</span><?php echo e(__('view.selected')); ?></div>

    <?php if((isset($permission) && auth()->user()->can($permission)) || !isset($permission)): ?>
        
        <button 
            type="button"
            data-action="<?php echo e($url); ?>"
            data-callback="<?php echo e($callback ?? 'reload-table'); ?>"
            data-table-id="<?php echo e(isset($table_id) ? $table_id : ''); ?>"
            data-model-name="<?php echo e($model_name); ?>"
            data-modal-action="<?php echo app('translator')->get('view.delete'); ?>"
            data-modal-message="<?php echo app('translator')->get('view.modal_message_delete'); ?>"
            data-time-alert="2000"
            data-multi-delete="true"
            class="delete-row btn btn-danger btn-delete-selected me-2"
        >
            <?php echo app('translator')->get('view.delete_selected'); ?>
        </button>
    <?php endif; ?>

    <?php echo $__env->yieldContent('more-actions'); ?>
</div>





<?php $__env->startPush('js-component'); ?>
<script>
    // reset title checkbox all items
    setTimeout(function() {
        $('#<?php echo e($table_id); ?>_wrapper .checkbox-all-rows').attr('title', 'Select items')
    }, 1000)

    function checkSelected() {
        var selected = [],
            table = $('#<?php echo e($table_id); ?>');
        table.find('.checkbox-row').each(function (i, e) {
            if ($(this)[0].checked) {
                selected.push(i)
            }
        })
        return selected.length == table.find('.checkbox-row').length;
    }

    function checkSelectedOneAtleast() {
        var table = $('#<?php echo e($table_id); ?>');
        return table.find('.checkbox-row').is(':checked');
    }

    function toggleShowActions() {
        var actions = $('#<?php echo e($table_id); ?>_selected_component'),
            filter = $('#<?php echo e($table_id); ?>_custom_filter'),
            checkboxAllRows = $('#<?php echo e($table_id); ?>_wrapper .checkbox-all-rows');

        setTimeout(() => {
            if (checkSelected()) {
                checkboxAllRows.prop('checked', true)
            } else {
                checkboxAllRows.prop('checked', false)
            }
            
            if (checkSelectedOneAtleast()) {
                actions.removeClass('d-none')
                filter.addClass('d-none')
            } else {
                actions.addClass('d-none')
                filter.removeClass('d-none')
            }
        });
    }

    // choose all rows
    $('body').on('change', '#<?php echo e($table_id); ?>_wrapper .checkbox-all-rows', function(e) {
        var table = $('#<?php echo e($table_id); ?>'),
            checkboxAllRows = $(this),
            selectedAll = checkboxAllRows[0].checked,
            checkBoxRowsNotSelected = table.find('.checkbox-row:not(:checked)'),
            checkBoxRowsSelected = table.find('.checkbox-row:checked'),
            checkBoxRowsAll = table.find('.checkbox-row');

        if (selectedAll) {
            // toggle not seleced only
            checkBoxRowsNotSelected.click()
        } else {
            // toggle selected only
            checkBoxRowsSelected.click();
        }
    });
    
    // choose one row
    $('body').on('change', '.checkbox-row', function(e) {
        toggleShowActions();
        setTimeout(() => {
            var actions = $('#<?php echo e($table_id); ?>_selected_component'),
                selectedCount = actions.find('.selected-count')
                table = $('#<?php echo e($table_id); ?>'),
                checkBoxSeleced = table.find('.checkbox-row:checked'),
                btnDelete = actions.find('.delete-row')
                idsSelected = []
            // add count selected to html
            selectedCount.text(checkBoxSeleced.length)
            // get all ids selected
            checkBoxSeleced.each(function(e, ele) {
                var id = $(ele).data('row-id')
                idsSelected.push(id)
            })
            // add ids to btn data to passing modal deleting in js
            btnDelete.attr('data-request-data', JSON.stringify(idsSelected))
            actions.attr('data-request-data', JSON.stringify(idsSelected))
        });
    });


</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/resources/views/adminLte/components/modules/datatable/columns/checkbox-actions.blade.php ENDPATH**/ ?>