<form>

    <div class="social-counters-widget-form" data-id="<?php echo e($id); ?>">
        <div class="single-social-counter p-4 mb-5 border border-secondary rounded bg-white shadow-sm copy d-none">
            <div class="mb-2 d-flex justify-content-end">
                <span class="remove-platform cursor-pointer" title="<?php echo app('translator')->get('view.remove_platform'); ?>">
                    <i class="fas fa-trash fs-6 fa-fw"></i>
                </span>
            </div>
            <!--begin::Input group platform -->
            <div class="mb-6">
                <label class="fw-bold fs-6"> <?php echo app('translator')->get('view.social_counters_data.platform'); ?> </label>
                <div class="mb-4">
                    <select
                        class="form-select platform-select"
                    >
                        <?php $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($platform['id']); ?>"><?php echo e($platform['name']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <!--end::Input group platform -->
        
            <!--begin::Input group count -->
            <div>
                <label class="fw-bold fs-6"> <?php echo app('translator')->get('view.social_counters_data.count'); ?> </label>
                <div class="mb-2">
                    <input
                        type="text"
                        placeholder="<?php echo app('translator')->get('view.example'); ?>: 25"
                        class="form-control platform-count"
                    >
                </div>
            </div>
            <!--end::Input group count -->
        </div>

        <div class="social-counters">
            <?php $__currentLoopData = $oldData['socials']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
                <div class="single-social-counter p-4 mb-5 border border-secondary rounded bg-white shadow-sm">
                    <div class="mb-2 d-flex justify-content-end">
                        <span class="remove-platform cursor-pointer" title="<?php echo app('translator')->get('view.remove_platform'); ?>">
                            <i class="fas fa-trash fs-6 fa-fw"></i>
                        </span>
                    </div>
                    <!--begin::Input group platform -->
                    <div class="mb-6">
                        <label class="fw-bold fs-6 required"> <?php echo app('translator')->get('view.social_counters_data.platform'); ?> </label>
                        <div class="mb-4">
                            <select
                                class="form-select platform-select"
                                name="socials.<?php echo e($index); ?>.platform"
                            >
                                <?php $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($platform['id']); ?>" <?php echo e(isset($social['platform']) && $social['platform'] == $platform['id'] ? 'selected' : ''); ?>><?php echo e($platform['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <!--end::Input group platform -->
                
                    <!--begin::Input group count -->
                    <div>
                        <label class="fw-bold fs-6 required"> <?php echo app('translator')->get('view.social_counters_data.count'); ?> </label>
                        <div class="mb-2">
                            <input
                                type="text"
                                name="socials.<?php echo e($index); ?>.count"
                                placeholder="<?php echo app('translator')->get('view.example'); ?>: 25"
                                class="form-control platform-count"
                                value="<?php echo e(isset($social['count']) ? $social['count'] : ''); ?>"
                            >
                        </div>
                    </div>
                    <!--end::Input group count -->
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        <div class="d-flex justify-content-end">
            <button
                class="btn btn-primary btn-sm add-new-platform"
                type="button"
            >
                <?php echo app('translator')->get('view.add_new_platform'); ?>
                <i class="fas fa-plus ms-1"></i>
            </button>
        </div>
    </div>

</form>

<script class="social-counters-widget-form-script">

    if ($('.social-counters-widget-form-script').length <= 1) {

        $(document).on('click', '.social-counters-widget-form .remove-platform', function () {
            $(this).parents('.single-social-counter').remove();
        });

        $(document).on('click', '.social-counters-widget-form .add-new-platform', function () {
            var self = $(this),
                parentForm = self.parents('.social-counters-widget-form'),
                wrapperSocials = parentForm.find('.social-counters'),
                cloneCopied = parentForm.find('.single-social-counter.copy').clone(),
                newIndex    = wrapperSocials.find('.single-social-counter').length;
                
            cloneCopied.removeClass('copy d-none')
            cloneCopied.find('.platform-select').attr('name', 'socials.' + newIndex + '.platform')
            cloneCopied.find('.platform-count').attr('name', 'socials.' + newIndex + '.count')
            wrapperSocials.append(cloneCopied)
        });
    }

</script><?php /**PATH C:\xampp\htdocs\resources\views/widgets/socialcounters/form.blade.php ENDPATH**/ ?>