

<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('currency::view.currencies')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php
    $user_role = auth()->user()->role;
    $admin  = 1;
    $branch = 3;
    $classColTable = ($user_role == 1 || auth()->user()->can('create-currencies')) ? 'col-lg-12' : 'col-12';
?>

<div class="row">
    <?php if(auth()->user()->can('set-default-currency') || $user_role == $admin ): ?>
        <div class="col-lg-12">
            <div class="side-form">
                <!--begin:: Form Card-->
                <div class="card mb-5 mb-xl-10">
                    <!--begin::Card header-->
                    
                    <div class="card-header">
                        <!--begin::Card title-->
                        <div class="card-title m-0">
                            <h3 class="fw-bolder m-0"><?php echo e(__('currency::view.systemd_default_currency')); ?></h3>
                        </div>
                        <!--end::Card title-->
                    </div>
                    <!--begin::Card header-->
                    <!--begin::Content-->
                    <div>
                        <!--begin::Form-->
                        <form class="form" action="<?php echo e(fr_route('currency.update_default_currency')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <!--begin::Card body-->
                            <div class="card-body border-top p-9">

                                <select class="form-control aiz-selectpicker" 
                                    data-control="select2"
                                    data-allow-clear="true"
                                    name="system_default_currency"
                                >
                                    <?php $__currentLoopData = $active_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($currency->id); ?>" <?php if( $currency->default == 1): ?>  selected <?php endif; ?> ><?php echo e($currency->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                            </div>
                            <!--end::Card body-->
                            <!--begin::Actions-->
                            <div class="card-footer d-flex justify-content-end py-6 px-9">
                                <button type="submit" class="btn btn-sm btn-primary"><?php echo app('translator')->get('view.save'); ?></button>
                            </div>
                            <!--end::Actions-->
                        </form>
                        <!--end::Form-->
                    </div>
                    <!--end::Content-->
                </div>
                <!--end:: Form Card-->
            </div>
        </div>
    <?php endif; ?>
    <?php if(auth()->user()->can('create-currencies') || $user_role == $admin ): ?>
        <div class="col-lg-12">
            <div class="side-form">
                <!--begin:: Form Card-->
                <div class="card mb-5 mb-xl-10">
                    <!--begin::Card header-->
                    
                    <div class="card-header">
                        <!--begin::Card title-->
                        <div class="card-title m-0">
                            <h3 class="fw-bolder m-0"><?php echo e(__('view.create_new')); ?></h3>
                        </div>
                        <!--end::Card title-->
                    </div>
                    <!--begin::Card header-->
                    <!--begin::Content-->
                    <div>
                        <!--begin::Form-->
                        <form class="form" action="<?php echo e(fr_route('currencies.store')); ?>" method="post" enctype="multipart/form-data">
                            <!--begin::Card body-->
                            <div class="card-body border-top p-9">
                                <?php echo $__env->make('currency::adminLte.pages.currencies.form', ['typeForm' => 'create'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <!--end::Card body-->
                            <!--begin::Actions-->
                            <div class="card-footer d-flex justify-content-end py-6 px-9">
                                <button type="reset" class="btn btn-sm btn-light btn-active-light-primary me-2"><?php echo e(__('view.reset')); ?></button>
                                <button type="submit" class="btn btn-sm btn-primary"><?php echo app('translator')->get('view.create'); ?></button>
                            </div>
                            <!--end::Actions-->
                        </form>
                        <!--end::Form-->
                    </div>
                    <!--end::Content-->
                </div>
                <!--end:: Form Card-->
            </div>
        </div>
    <?php endif; ?>

    <div class="<?php echo e($classColTable); ?>">
        <div class="side-table">
            <!--begin:: Table Card-->
            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    <div class="card-title">
        
                        <!--begin::Search-->
                        
                        <?php echo $__env->make('adminLte.components.modules.datatable.search', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <!--end::Search-->
        
                    </div>
                    <!--begin::Card title-->
        
                    <!--begin::Card toolbar-->
                    <div class="card-toolbar">
                        <!--begin::Toolbar-->
                        <div class="d-flex flex-wrap align-items-center" id="<?php echo e($table_id); ?>_custom_filter">
                            
                            <?php echo $__env->make('adminLte.components.modules.datatable.datatable_length', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            
                            <?php echo $__env->make('adminLte.components.modules.datatable.reload', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
                            <!--begin::Filter-->
                            <?php if (isset($component)) { $__componentOriginal6166a680511730b9b409b675564b2279cb9dec75 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\TableFilter::class, []); ?>
<?php $component->withName('table-filter'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['table_id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($table_id),'filters' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($filters)]); ?>
        
                                

                                
        
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6166a680511730b9b409b675564b2279cb9dec75)): ?>
<?php $component = $__componentOriginal6166a680511730b9b409b675564b2279cb9dec75; ?>
<?php unset($__componentOriginal6166a680511730b9b409b675564b2279cb9dec75); ?>
<?php endif; ?>
                            <!--end::Filter-->
        
                            <?php if(auth()->user()->can('export-table-currencies') || $user_role == $admin ): ?>
                                <!-- ================== begin export buttons =============================== -->
                                <?php echo $__env->make('adminLte.components.modules.datatable.export', ['table_id' => $table_id, 'btn_exports' => $btn_exports], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <!-- ================== end export buttons =============================== -->
                            <?php endif; ?>
        
                        </div>
                        <!--end::Toolbar-->
        
                        <!--begin::Group actions-->
                        <?php echo $__env->make('adminLte.components.modules.datatable.columns.checkbox-actions', [
                            'table_id' => $table_id,
                            'permission' => 'delete-currencies',
                            'url' => fr_route('currencies.multi-destroy'),
                            'callback' => 'reload-table',
                            'model_name' => __('currency::view.selected_currencies')
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <!--end::Group actions-->
        
                    </div>
                    <!--end::Card toolbar-->
                </div>
                <!--end::Card header-->
        
        
                <!--begin::Card body-->
                <div class="card-body pt-6">
        
                    <!--begin::Table-->
                    <?php echo e($dataTable->table()); ?>

                    <!--end::Table-->
        
        
                </div>
                <!--end::Card body-->
            </div>
            <!--end:: Table Card-->
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/lte/plugins/custom/datatables/datatables.bundle.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/lte/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <?php echo e($dataTable->scripts()); ?>


    <script>
        function update_currency_status(el){
            var id = $(el).data('row-id');
            if(el.checked){
                var status = 1;
            }
            else{
                var status = 0;
            }

            $.post('<?php echo e(route('currency.update_status')); ?>', {_token:'<?php echo e(csrf_token()); ?>', id:id, status:status}, function(data){
                if(data == 1){
                    Swal.fire("<?php echo e(__('currency::messages.saved')); ?>", "", "");
                }
                else{
                    Swal.fire("<?php echo e(__('currency::messages.something_wrong')); ?>", "", "");
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('currency::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Modules/Currency\Resources/views/adminLte/pages/currencies/index.blade.php ENDPATH**/ ?>