
<?php
    function youAuth($creator, $creator_cookie = false) {
        $you = false;
        if ($creator_cookie) {
            $you = $creator->author_email == (get_comment_author() ? get_comment_author()->author_email : null);
        } else {
            if (auth()->check()) {
                $you = $creator->id == auth()->id();
            }
        }
        return $you ? ' (' . __('blog::front.you') . ')' : '';
    }
?>


<div id="comments" class="comments-container">
    <div class="widget-box-title widget-box-title-s4">
        <h3> <span id="comment_count_show"><?php echo e($post['approved_comments_count']); ?></span> <?php echo app('translator')->get('blog::front.comments'); ?> </h3>
    </div>

    <div class="get-perv-comments">
        <?php if($post['comments_count'] > 10): ?>
            <a
                rel="nofollow"
                class="get-prev-comments get-prev-comment-btn"
                id="get_prev_comment_btn"
                href="javascript:void()"
                data-url="<?php echo e(route('comments.loadMore')); ?>"
                data-post-id="<?php echo e($post['id']); ?>"
                data-comments-count="<?php echo e($post['comments_count']); ?>"
                data-comments-offset="<?php echo e($comments->count()); ?>"
            >
                <?php echo app('translator')->get('blog::front.view_prev_comments'); ?>
                <span class="loading-icon hide-load">
                    <i class="fa fa-circle-o-notch fa-spin"></i>
                </span>
            </a>
        <?php endif; ?>
    </div>

    


    <ol class="comment-list comments_list level1">
        <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li id="comment-<?php echo e($comment->id); ?>" class="comment byuser comment-author-admin bypostauthor even thread-odd thread-alt depth-1 parent">
                <article id="div-comment-<?php echo e($comment->id); ?>" class="comment-body <?php echo e($comment->approved == 0 ? 'pending' : ''); ?>">
                    <?php if($comment->approved == 0): ?>
                        <div class="pending-badge">
                            <div class="text-badge">
                                <?php echo app('translator')->get('blog::front.waiting_for_approval'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <footer class="comment-meta">
                        <div class="comment-author vcard">
                            <img alt="<?php echo e($comment->creator ? $comment->creator->name : 'not auth'); ?>"
                                data-srcset="<?php echo e($comment->creator ? $comment->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                style="width: 50px;height: 50px;"
                                data-src="<?php echo e($comment->creator? $comment->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                class="avatar avatar-50 photo lazyloaded visible full-visible"
                                src="<?php echo e($comment->creator ? $comment->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                loading="lazy"
                                srcset="<?php echo e($comment->creator ? $comment->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                            >
                                <b class="fn">
                                    <?php if($comment->creator): ?>
                                        <a href="<?php echo e(route('author-page', ['username' => $comment->creator->name ])); ?>" rel="external nofollow ugc" class="url">
                                            <?php echo e($comment->creator->name . youAuth($comment->creator)); ?>

                                        </a>
                                    <?php else: ?>
                                        <span class="url">
                                            <?php echo e($comment->author_name . youAuth($comment, true)); ?>

                                        </span>
                                    <?php endif; ?>
                                </b>
                            </div>
                        <div class="comment-metadata">
                            <time datetime="<?php echo e($comment->created_at); ?>">
                                <?php echo e($comment->date); ?>

                            </time>
                        </div>
                    </footer>
                    <div class="comment-content">
                        <p> <?php echo e($comment->content); ?> </p>
                    </div>
                    <div class="reply">
                        <a
                            rel="nofollow" class="comment-reply-btn"
                            href="javascript:void()"
                            data-comment-id="<?php echo e($comment->id); ?>"
                            data-level="2"
                            data-reply-to="<?php echo app('translator')->get('blog::front.reply_to'); ?> <?php echo e($comment->creator ? $comment->creator->name : $comment->author_name); ?>"
                        >
                            <?php echo app('translator')->get('blog::front.reply'); ?>
                        </a>
                    </div>
                </article>

                <?php if($comment->comments_count > 3): ?>
                    <div class="get-perv-replies">
                        <a
                            rel="nofollow"
                            class="get-prev-comments get-prev-replies-btn"
                            href="javascript:void()"
                            data-url="<?php echo e(route('comments.loadMoreReplies')); ?>"
                            data-comment-id="<?php echo e($comment->id); ?>"
                            data-replies-level="2"
                            data-comments-count="<?php echo e($comment->comments_count); ?>"
                            data-comments-offset="<?php echo e($comment->comments->count()); ?>"
                        >
                            <?php echo app('translator')->get('blog::front.view_prev_replies'); ?>
                            <span class="loading-icon hide-load">
                                <i class="fa fa-circle-o-notch fa-spin"></i>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>

                <ol class="children comments_list level2" data-comment-id="<?php echo e($comment->id); ?>">
                    <?php $__currentLoopData = $comment->comments->reverse(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment_2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li id="comment-<?php echo e($comment_2->id); ?>" class="comment">
                            <article id="div-comment-<?php echo e($comment_2->id); ?>" class="comment-body <?php echo e($comment_2->approved == 0 ? 'pending' : ''); ?>">
                                <?php if($comment_2->approved == 0): ?>
                                    <div class="pending-badge">
                                        <div class="text-badge">
                                            <?php echo app('translator')->get('blog::front.waiting_for_approval'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <footer class="comment-meta">
                                    <div class="comment-author vcard">
                                        <img alt="<?php echo e($comment_2->creator ? $comment_2->creator->name : 'not auth'); ?>"
                                            data-srcset="<?php echo e($comment_2->creator ? $comment_2->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                            style="width: 50px;height: 50px;"
                                            data-src="<?php echo e($comment_2->creator ? $comment_2->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                            class="avatar avatar-50 photo lazyloaded visible full-visible"
                                            src="<?php echo e($comment_2->creator ? $comment_2->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                            loading="lazy"
                                            srcset="<?php echo e($comment_2->creator ? $comment_2->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                        >
                                            <b class="fn">
                                                <?php if($comment_2->creator): ?>
                                                    <a href="<?php echo e(route('author-page', ['username' => $comment_2->creator->name ])); ?>" rel="external nofollow ugc" class="url">
                                                        <?php echo e($comment_2->creator->name . youAuth($comment_2->creator)); ?>

                                                    </a>
                                                <?php else: ?>
                                                    <span class="url">
                                                        <?php echo e($comment_2->author_name . youAuth($comment_2, true)); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </b>
                                        </div>
                                    <div class="comment-metadata">
                                        <time datetime="<?php echo e($comment_2->created_at); ?>">
                                            <?php echo e($comment_2->date); ?>

                                        </time>
                                    </div>
                                </footer>
                                <div class="comment-content">
                                    <p> <?php echo e($comment_2->content); ?> </p>
                                </div>
                                <div class="reply">
                                    <a
                                        rel="nofollow" class="comment-reply-btn"
                                        href="javascript:void()"
                                        data-comment-id="<?php echo e($comment_2->id); ?>"
                                        data-level="3"
                                        data-reply-to="<?php echo app('translator')->get('blog::front.reply_to'); ?> <?php echo e($comment_2->creator ? $comment_2->creator->name : $comment_2->author_name); ?>"
                                        >
                                        <?php echo app('translator')->get('blog::front.reply'); ?>
                                    </a>
                                </div>
                            </article>

                            <div class="get-perv-replies">
                                <?php if($comment_2->comments_count > 3): ?>
                                    <a
                                        rel="nofollow"
                                        class="get-prev-comments get-prev-replies-btn"
                                        href="javascript:void()"
                                        data-url="<?php echo e(route('comments.loadMoreReplies')); ?>"
                                        data-comment-id="<?php echo e($comment_2->id); ?>"
                                        data-replies-level="3"
                                        data-comments-count="<?php echo e($comment_2->comments_count); ?>"
                                        data-comments-offset="<?php echo e($comment_2->comments->count()); ?>"
                                    >
                                        <?php echo app('translator')->get('blog::front.view_prev_replies'); ?>
                                        <span class="loading-icon hide-load">
                                            <i class="fa fa-circle-o-notch fa-spin"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </div>

                            <ol class="children comments_list level3" data-comment-id="<?php echo e($comment_2->id); ?>">
                                <?php $__currentLoopData = $comment_2->comments->reverse(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment_3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li id="comment-<?php echo e($comment_3->id); ?>" class="comment">
                                        <article id="div-comment-<?php echo e($comment_3->id); ?>" class="comment-body <?php echo e($comment_3->approved == 0 ? 'pending' : ''); ?>">
                                            <?php if($comment_3->approved == 0): ?>
                                                <div class="pending-badge">
                                                    <div class="text-badge">
                                                        <?php echo app('translator')->get('blog::front.waiting_for_approval'); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <footer class="comment-meta">
                                                <div class="comment-author vcard">
                                                    <img alt="<?php echo e($comment_3->creator ? $comment_3->creator->name : 'not auth'); ?>"
                                                        data-srcset="<?php echo e($comment_3->creator ? $comment_3->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                                        style="width: 50px;height: 50px;"
                                                        data-src="<?php echo e($comment_3->creator ? $comment_3->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                                        class="avatar avatar-50 photo lazyloaded visible full-visible"
                                                        src="<?php echo e($comment_3->creator ? $comment_3->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                                        loading="lazy"
                                                        srcset="<?php echo e($comment_3->creator ? $comment_3->creator->getFirstMediaUrl('avatar') : asset('assets/lte/media/avatars/blank.png')); ?>"
                                                    >
                                                        <b class="fn">
                                                            <?php if($comment_3->creator): ?>
                                                                <a href="<?php echo e(route('author-page', ['username' => $comment_3->creator->name ])); ?>" rel="external nofollow ugc" class="url">
                                                                    <?php echo e($comment_3->creator->name . youAuth($comment_3->creator)); ?>

                                                                </a>
                                                            <?php else: ?>
                                                                <span class="url">
                                                                    <?php echo e($comment_3->author_name . youAuth($comment_3, true)); ?>

                                                                </span>
                                                            <?php endif; ?>
                                                        </b>
                                                    </div>
                                                <div class="comment-metadata">
                                                    <time datetime="<?php echo e($comment_3->created_at); ?>">
                                                        <?php echo e($comment_3->date); ?>

                                                    </time>
                                                </div>
                                            </footer>
                                            <div class="comment-content">
                                                <p> <?php echo e($comment_3->content); ?> </p>
                                            </div>
                                        </article>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ol>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ol>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ol>



    <div class="comments-navigation">
        <div class="alignleft"></div>
        <div class="alignright"></div>
    </div>

    <div id="parent-respond">
        <div id="respond" class="comment-respond">
            <div class="widget-box-title widget-box-title-s4">
                <h3 id="reply-title" class="comment-reply-title">
                    <span class="text-title">
                        <?php echo app('translator')->get('blog::front.leave_reply'); ?>
                    </span>
                    <small>
                        <a
                            rel="nofollow"
                            class="cancel-comment-reply-link"
                            href="javascript:void()"
                            style="margin: 0 10px; display:none;"
                        >
                            <?php echo app('translator')->get('blog::front.leave_reply'); ?>
                        </a>
                    </small>
                    </h3>
            </div>
            <form
                id="commentform"
                class="comment-form"
                action="<?php echo e(route('comments.store')); ?>"
                data-post-id="<?php echo e($post['id']); ?>"
                data-level="1"
                data-author-page="<?php echo e(url('author')); ?>"
                >
                <?php echo csrf_field(); ?>
                <p class="comment-notes">
                    <span id="email-notes">
                    <?php echo app('translator')->get('blog::front.msg_email_published'); ?>
                    </span>
                    <?php echo app('translator')->get('blog::front.fields_are_marked'); ?>
                    <span class="required">*</span>
                </p>

                <p class="comment-form-comment">
                    <label class="label_content" for="comment_content"><?php echo app('translator')->get('blog::front.field_comment'); ?></label>
                    <textarea
                        placeholder="<?php echo app('translator')->get('blog::front.field_comment'); ?>"
                        id="comment_content"
                        name="content"
                        cols="45"
                        rows="8"
                        maxlength="65000"
                        
                    ></textarea>
                    <span class="invalid-feedback"></span>
                </p>

                <?php if(!auth()->check()): ?>

                    <p class="comment-form-author">
                        <label class="label_author_name" for="comment_author_name"><?php echo app('translator')->get('blog::front.field_name'); ?> <span class="required">*</span></label>
                        <input
                            placeholder="<?php echo app('translator')->get('blog::front.field_name'); ?>"
                            id="comment_author_name"
                            name="author_name"
                            type="text"
                            value="<?php echo e(get_comment_author() ? get_comment_author()->author_name : ''); ?>"
                            size="30"
                            maxlength="100"
                            
                        >
                        <span class="invalid-feedback"></span>
                    </p>

                    <p class="comment-form-email">
                        <label class="label_author_email" for="comment_author_email"><?php echo app('translator')->get('blog::front.field_email'); ?> <span class="required">*</span></label>
                        <input
                            placeholder="<?php echo app('translator')->get('blog::front.field_email'); ?>"
                            id="comment_author_email"
                            name="author_email"
                            type="email"
                            value="<?php echo e(get_comment_author() ? get_comment_author()->author_email : ''); ?>"
                            size="30"
                            maxlength="100"
                            aria-describedby="email-notes"
                            
                        >
                        <span class="invalid-feedback"></span>
                    </p>

                    <p class="comment-form-website">
                        <label class="label_author_website" for="comment_author_website"><?php echo app('translator')->get('blog::front.field_website'); ?></label>
                        <input
                            placeholder="<?php echo app('translator')->get('blog::front.field_website'); ?>"
                            id="comment_author_website"
                            name="author_website"
                            type="url"
                            value="<?php echo e(get_comment_author() ? get_comment_author()->author_website : ''); ?>"
                            size="30"
                            maxlength="200"
                        >
                        <span class="invalid-feedback"></span>
                    </p>

                    <p class="comment-form-cookies-consent">
                        <input
                            id="comment_cookies"
                            name="comment_cookies"
                            type="checkbox"
                            <?php echo e(get_comment_author() ? 'checked="checked"' : ''); ?>

                            value="1"
                        >
                        <label for="comment_cookies">
                            <?php echo app('translator')->get('blog::front.msg_save_author_data'); ?>
                        </label>
                    </p>

                <?php endif; ?>

                <div id="alert-error-new-comment" class="alert-error hide">
                    <div class="text-error"></div>
                </div>
                <p class="form-submit">
                    <button
                        name="submit"
                        type="submit"
                        id="submit"
                        class="btn btn-submit submit"
                    >
                        <?php echo app('translator')->get('blog::front.post_comment'); ?>
                        <i class="loading-icon fa fa-circle-o-notch fa-spin hide-load"></i>
                    </button>
                </p>
            </form>
        </div>
    </div>

</div>



<?php /**PATH /home/elitedesigncom/courier.elitedesign.com.bd/themes/easyship/views/theme/components/comments/post-comments.blade.php ENDPATH**/ ?>