<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    
    <title><?php echo $__env->yieldContent('page-title'); ?> | <?php echo e(\Str::title(get_general_setting('website_title', config('app.name')))); ?> </title>
    <meta name="description" content="<?php echo $__env->yieldContent('page-description', get_general_setting('website_description', config('app.description'))); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('page-keywords',  get_general_setting('website_keywords')); ?>">
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
    <?php 
        $model = App\Models\Settings::where('group', 'general')->where('name','system_logo')->first();
    ?>
    <link rel="shortcut icon" href="<?php echo e($model->getFirstMediaUrl('system_logo') ? $model->getFirstMediaUrl('system_logo') : asset('assets/lte/media/logos/favicon.ico')); ?>" />
    
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo $__env->yieldContent('page-title'); ?> | <?php echo e(get_general_setting('website_title', config('app.name'))); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('page-description', get_general_setting('website_description', config('app.description'))); ?>">
    <meta property="og:type" content="<?php echo $__env->yieldContent('page-type', 'website'); ?>">
    <meta property="og:image" content="<?php echo $__env->yieldContent('page-image', get_general_setting('social_media_image')); ?>">

    
    <?php echo $__env->make('theme.layout.layout-components.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <?php echo $__env->yieldContent('styles'); ?>


    <?php echo $__env->yieldPushContent('prepend-scripts'); ?>
</head>
<body
        class="home page-template-default page wp-embed-responsive has-lazy-load"
        itemscope="itemscope"
        itemtype="https://schema.org/WebPage"
>


<?php echo $__env->make('theme.layout.layout-components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




<?php echo $__env->yieldContent('before-page'); ?>



<?php echo $__env->yieldContent('content'); ?>



<?php echo $__env->yieldContent('after-page'); ?>


<?php echo $__env->make('theme.layout.layout-components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




<div class="gotop" title="Go Top"><span class="bdaia-io bdaia-io-ion-android-arrow-up"></span></div>




<?php echo $__env->make('theme.layout.layout-components.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<?php echo $__env->yieldContent('scripts'); ?>

<?php echo $__env->yieldPushContent('push-scripts'); ?>

</body>
</html><?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/themes/easyship/views/theme/layout/layout-theme.blade.php ENDPATH**/ ?>