<?php
    $user_role = auth()->user()->role;
    $admin  = 1;
    $auth_staff  = 0;
    $auth_branch = 3;
    $auth_client = 4;

    $date_now = \Carbon\Carbon::now()->format('d-m-Y');
    $paymentSettings = resolve(\Modules\Payments\Entities\PaymentSetting::class)->toArray();

    $clients   = Modules\Cargo\Entities\Client::where('is_archived', 0)->get();
    
    $file_name = 'import_shipment_admin.csv';
    if($user_role == $auth_branch){
        $userBranch = Modules\Cargo\Entities\Branch::where('user_id',auth()->user()->id)->first();
        $clients    = Modules\Cargo\Entities\Client::where('branch_id', $userBranch->id )->get();
    }elseif(auth()->user()->can('import-shipments')  && $user_role == $auth_staff){
        $userStaff  = Modules\Cargo\Entities\Staff::where('user_id',auth()->user()->id)->first();
        $clients    = Modules\Cargo\Entities\Client::where('branch_id', $userStaff->branch_id )->get();
    }elseif($user_role == $auth_client){
        $file_name = 'import_shipment_customer.csv';
        $userClient = Modules\Cargo\Entities\Client::where('user_id',auth()->user()->id)->first();
        $addresses  = Modules\Cargo\Entities\ClientAddress::where('client_id', $userClient->id )->get();
    } 
?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.import_shipments')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="mx-auto mb-5 col-lg-12">

        <div class="alert alert-danger" role="alert">
            <?php echo e(__('cargo::view.please_be_sure_shipments_have_right_branch')); ?>.
        </div>

        <div class="card mb-5">
            <div class="card-header" style="display: flex;align-items: center;">
                <h5 style="display: inline;"><?php echo e(__('cargo::view.shipment_CSV_Import')); ?></h5>

                <a href="<?php if($user_role == $auth_client): ?> <?php echo e(asset($file_name)); ?> <?php else: ?> <?php echo e(asset($file_name)); ?> <?php endif; ?>" download="<?php echo e($file_name); ?>" style="float: right;" class="btn btn-sm btn-primary"><?php echo e(__('cargo::view.download_CSV')); ?></a>

            </div>
            <div class="card-body">
                <form class="form-horizontal" id="kt_form_1" action="<?php echo e(route('shipments.import_parse')); ?>" method="POST" enctype="multipart/form-data">
                	<?php echo csrf_field(); ?>

                    <div class="form-group mb-5 d-none">
                        <label><?php echo e(__('cargo::view.columns')); ?>:</label>
                        <select class="<?php $__errorArgs = ['columns'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> form-control select-items selectpicker" name="columns[]" multiple required>
                            <option value="type" selected>type</option>
                            <option value="branch_id" selected>branch_id</option>
                            <option value="shipping_date" selected>shipping_date</option>
                            <?php if($user_role != $auth_client): ?>
                                <option value="client_id" selected>client_id</option>
                            <?php endif; ?>
                            <option value="client_phone" selected>client_phone</option>
                            <option value="client_address" selected>client_address</option>
                            <option value="reciver_name" selected>reciver_name</option>
                            <option value="reciver_phone" selected>reciver_phone</option>
                            <option value="reciver_address" selected>reciver_address</option>
                            <option value="from_country_id" selected>from_country_id</option>
                            <option value="to_country_id" selected>to_country_id</option>
                            <option value="from_state_id" selected>from_state_id</option>
                            <option value="to_state_id" selected>to_state_id</option>
                            <option value="from_area_id" selected>from_area_id</option>
                            <option value="to_area_id" selected>to_area_id</option>
                            <option value="payment_type" selected>payment_type</option>
                            <option value="payment_method_id" selected>payment_method_id</option>
                            <option value="attachments_before_shipping" selected>attachments_before_shipping</option>
                            <option value="package_id" selected>package_id</option>

                            <option value="description" selected>description</option>
                            <option value="qty" selected>qty</option>
                            <option value="weight" selected>weight</option>
                            <option value="length" selected>length</option>
                            <option value="width" selected>width</option>
                            <option value="height" selected>height</option>

                            <option value="amount_to_be_collected" selected>amount_to_be_collected</option>
                            <option value="order_id" selected>order_id</option>
                            <option value="delivery_time" selected>delivery_time</option>
                            <option value="collection_time" selected>collection_time</option>
                        </select>
                        <?php $__errorArgs = ['columns'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                            <div class="invalid-feedback">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>

                    <div class="form-group mb-5">
                        <label for="shipments_file" class="col-md-12 control-label"><?php echo e(__('cargo::view.CSV_file_to_import')); ?></label>

                        <div class="col-md-12">
                            <input id="shipments_file" type="file" class="form-control <?php $__errorArgs = ['shipments_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="shipments_file" required>

                            <?php $__errorArgs = ['shipments_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mb-0 text-right form-group">
                        <button type="submit" class="btn btn-sm btn-primary"><?php echo e(__('cargo::view.parse_CSV')); ?></button>
                    </div>
                </form>
            </div>
        </div>

        <div class="mb-4 col-lg-12 card table-responsive table-custom-container">
            <table class="table table-hover ">
                <thead>
                    <tr>
                        <th scope="col"><?php echo e(__('cargo::view.parameters')); ?></th>
                        <th scope="col"><?php echo e(__('cargo::view.details')); ?></th>
                        <th scope="col"><?php echo e(__('cargo::view.description')); ?></th>
                        <th scope="col"><?php echo e(__('cargo::view.value')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    
                    <tr>
                        <td>type</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>Pickup = 1 / Drop off = 2</td>
                        <td>1 / 2</td>
                    </tr>
                    <tr>
                        <td>branch_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#branchs">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="branchs">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.branches')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.table.name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.value')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e($branch->name); ?></td>
                                                        <td><?php echo e($branch->id); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($branch->id); ?> /
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>shipping_date</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>DD/MM/YYYY</td>
                        <td><?php echo e($date_now); ?></td>
                    </tr>
                    <?php if($user_role != $auth_client): ?>
                        <tr>
                            <td>client_id</td>
                            <td>
                                <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                            </td>
                            <td>
                                <select
                                    class="form-control select-client"
                                    data-control="select2"
                                    data-placeholder="<?php echo e(__('cargo::view.choose_client')); ?>"
                                    data-allow-clear="true"
                                >
                                    <option></option>
                                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                        value="<?php echo e($client->id); ?>"
                                        data-phone="<?php echo e($client->responsible_mobile); ?>"
                                        data-id="<?php echo e($client->id); ?>"
                                        <?php echo e(old('Shipment.client_id') == $client->id ? 'selected' : ''); ?>

                                    > <?php echo e($client->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </td>
                            <td id="client_id">
                                
                            </td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td>client_phone</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td> <?php if($user_role != $auth_client): ?> - <?php else: ?> <?php echo e(__('cargo::view.default_is_your_phone')); ?> <?php endif; ?></td>
                        <td id="client_phone">-</td>
                    </tr>
                    <tr>
                        <td>client_address</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#addressess">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="addressess">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.your_addresses')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.table.name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.value')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="client_addresses">
                                                    <?php if($user_role == $auth_client): ?>
                                                        <?php $__empty_1 = true; $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr>
                                                            <td><?php echo e($address->address); ?></td>
                                                            <td><?php echo e($address->id); ?></td>
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                        </tr>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                            <td><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>reciver_name</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>reciver_phone</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>reciver_address</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>from_country_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#countries">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="countries">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.countries')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.table.name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.value')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $countrie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e($countrie->name); ?></td>
                                                        <td><?php echo e($countrie->id); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>to_country_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#countries">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>from_state_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#states">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="states">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.regions')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.table.name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.value')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e($state->name); ?></td>
                                                        <td><?php echo e($state->id); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>to_state_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#states">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>from_area_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#areas">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="areas">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.areas')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.region_name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.area_name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.area_id')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e($area->state->name); ?></td>
                                                        <td><?php echo e(json_decode($area->name, true)[app()->getLocale()]); ?></td>
                                                        <td><?php echo e($area->id); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>to_area_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#areas">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>
                        </td>
                        <td>
                        <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>payment_type</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>Postpaid = 1 / Prepaid = 2</td>
                        <td>1 / 2</td>
                    </tr>
                    <tr>
                        <td>payment_method_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#payments">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="payments">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.payment_method')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.table.name')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $paymentSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <?php if($gateway): ?>
                                                            <tr>
                                                                <td><?php echo e($key); ?></td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?></td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>attachments_before_shipping</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>package_id</td>
                        <td>
                            <span class="badge badge-danger"><?php echo e(__('cargo::view.required')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#packages">
                                <u><b><?php echo e(__('cargo::view.click_to_get_iD')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="packages">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.packages')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.table.name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.value')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e(json_decode($package->name, true)[app()->getLocale()]); ?></td>
                                                        <td><?php echo e($package->id); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php echo e(__('cargo::view.table.id')); ?> (<?php echo e(__('cargo::view.example')); ?>: 1)
                        </td>
                    </tr>
                    <tr>
                        <td>description</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>qty</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td><?php echo e(__('cargo::view.default_is_1')); ?></td>
                        <td>1</td>
                    </tr>
                    <tr>
                        <td>weight</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td><?php echo e(__('cargo::view.default_is_1')); ?></td>
                        <td>1</td>
                    </tr>
                    <tr>
                        <td>length</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td><?php echo e(__('cargo::view.default_is_1')); ?></td>
                        <td>1</td>
                    </tr>
                    <tr>
                        <td>width</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td><?php echo e(__('cargo::view.default_is_1')); ?></td>
                        <td>1</td>
                    </tr>
                    <tr>
                        <td>height</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td><?php echo e(__('cargo::view.default_is_1')); ?></td>
                        <td>1</td>
                    </tr>
                    <tr>
                        <td>amount_to_be_collected</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td><?php echo e(__('cargo::view.default_is_0')); ?></td>
                        <td>0</td>
                    </tr>
                    <tr>
                        <td>order_id</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>delivery_time</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td>
                            <p data-toggle="modal" data-target="#deliveryTimes">
                                <u><b><?php echo e(__('cargo::view.click_to_get_value')); ?></b></u>
                            </p>

                            <!-- The Modal -->
                            <div class="modal" id="deliveryTimes">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">
                                            <h4 class="modal-title"><?php echo e(__('cargo::view.delivery_times')); ?></h4>
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('cargo::view.table.name')); ?></th>
                                                        <th scope="col"><?php echo e(__('cargo::view.value')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $deliveryTimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deliveryTime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e(json_decode($deliveryTime->name, true)[app()->getLocale()]); ?></td>
                                                        <td><?php echo e($deliveryTime->id); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="2"><?php echo e(__('cargo::view.noting_found')); ?>!</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <td>collection_time</td>
                        <td>
                            <span class="badge badge-info"><?php echo e(__('cargo::view.optional')); ?></span>
                        </td>
                        <td>-</td>
                        <td>01:12:22 AM</td>
                    </tr>
                </tbody>
            </table>
        </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <style type="text/css">

        label {
            display: inline-block !important;
            margin-bottom: .5rem !important;
        }

        .gray{
            background-color: #f7f7f7 !important;
        }

        .badge-info {
            color: hsla(188, 60%, 30%, 1) !important;
            background-color: #bbeff7 !important;
        }
        .badge-danger {
            color: hsla(354, 70%, 35%, 1) !important;
            background-color: hsla(354, 70%, 85%, 1) !important;
        }

        table {
            border: 2px solid #f2f2f2 !important;
        }

        th{
            font-size: 1.2rem !important;
            padding: 1.6rem !important;
        }

        td{
            font-size: 78% !important;
            padding: 1.6rem !important;
        }

        tr:hover td {
            background-color: #f7f7f7 !important ;
        }
        p{
            cursor: pointer;
        }

    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js" integrity="sha384-vFJXuSJphROIrBnz7yo7oB41mKfc8JzQZiCq4NCceLEaO4IHwicKwpJf9c9IpFgh" crossorigin="anonymous"></script>
    <script>
        $('.select-items').select2({ placeholder: "<?php echo e(__('cargo::view.choose_country')); ?>" });
        $('.select-client').change(function(){
            var client_phone = $(this).find(':selected').data('phone');
            var client_id = $(this).find(':selected').data('id');
            getClientAddresses(client_id);
            $('#client_id').html(client_id);
            $('#client_phone').html(client_phone);
        })

        // Ajax Get Client Addresses By Id
        function getClientAddresses(client_id)
        {
            var id = client_id;
            $.get("<?php echo e(route('ajax-get-client-addresses-ajax')); ?>?client_id=" + id, function(data) {
                if(data.length != 0){
                    $('#client_addresses').empty();
                    for (let index = 0; index < data.length; index++) {
                        const element = data[index];
                        $('#client_addresses').append('<tr><td>' + element['address'] + '</td><td>' + element['id'] + '</td></tr>');
                    }
                }else{
                    $('#client_addresses').empty();
                    $('#client_addresses').append(`<tr><td><?php echo e(__('cargo::view.no_addresses_found')); ?></td><td><?php echo e(__('cargo::view.no_addresses_found')); ?></td></tr>`);
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/shipments/import.blade.php ENDPATH**/ ?>