<?php
    $user_role = auth()->user()->role;
    $admin  = 1;
    $staff  = 0;
    $auth_branch = 3;
    $auth_client = 4;
    $auth_driver = 5;

    $count = (Modules\Cargo\Entities\ShipmentSetting::getVal('latest_shipment_count') ? Modules\Cargo\Entities\ShipmentSetting::getVal('latest_shipment_count') : 10 );
    if($user_role == $admin || $user_role == $staff){
        if($user_role == $admin || auth()->user()->can('manage-shipments')){
            $shipments = Modules\Cargo\Entities\Shipment::limit($count)->orderBy('id','desc')->get();
        }
        if($user_role == $admin || auth()->user()->can('manage-drivers')){
            $captains  = Modules\Cargo\Entities\Driver::withCount(['transaction AS wallet' => function ($query) { $query->select(DB::raw("SUM(value)")); }])->get();
        }
    }elseif($user_role == $auth_branch){
        $branch_id = Modules\Cargo\Entities\Branch::where('user_id',auth()->user()->id)->pluck('id')->first();
        $shipments = Modules\Cargo\Entities\Shipment::where('branch_id', $branch_id)->limit($count)->orderBy('id','desc')->get();
        $captains  = Modules\Cargo\Entities\Driver::where('branch_id', $branch_id)->withCount(['transaction AS wallet' => function ($query) { $query->select(DB::raw("SUM(value)")); }])->get();
    }elseif($user_role == $auth_client){
        $client_id = Modules\Cargo\Entities\Client::where('user_id',auth()->user()->id)->pluck('id')->first();
        $shipments = Modules\Cargo\Entities\Shipment::limit($count)->orderBy('id','desc')->where('client_id',$client_id)->get();
    }elseif($user_role == $auth_driver){
        $driver_id = Modules\Cargo\Entities\Driver::where('user_id',auth()->user()->id)->pluck('id')->first();
    }
?>

<?php if(in_array($user_role ,[$admin,$auth_branch,$auth_client]) || auth()->user()->can('manage-shipments') ): ?>
    <div class="col-md-12">
        <div class="card card-custom card-stretch">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label"><?php echo e(__('cargo::view.latest_shipments')); ?></h3>
                </div>
            </div>
            <div class="card-body">

                <table class="table mb-0 aiz-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('cargo::view.table.code')); ?></th>
                            <th><?php echo e(__('cargo::view.status')); ?></th>
                            <th><?php echo e(__('cargo::view.table.type')); ?></th>
                            <th><?php echo e(__('cargo::view.client')); ?></th>

                            <?php if($user_role != $auth_branch): ?>
                                <th><?php echo e(__('cargo::view.table.branch')); ?></th>
                            <?php endif; ?>

                            <th><?php echo e(__('cargo::view.shipping_cost')); ?></th>
                            <th><?php echo e(__('cargo::view.payment_method')); ?></th>
                            <th><?php echo e(__('cargo::view.shipping_date')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>

                            <td width="5%"><a href="<?php echo e(route('shipments.show',$shipment->id)); ?>"><?php echo e($shipment->code); ?></a></td>
                            <td><?php echo e($shipment->getStatus()); ?></td>
                            <td><?php echo e($shipment->type); ?></td>
                            <td>
                                <?php if(in_array($user_role ,[$admin,$auth_branch]) || auth()->user()->can('manage-customers') ): ?>
                                    <a href="<?php echo e(route('clients.show',$shipment->client_id)); ?>"><?php echo e($shipment->client->name ?? 'No Client Name'); ?></a>
                                <?php else: ?>
                                    <?php echo e($shipment->client->name); ?>

                                <?php endif; ?>
                            </td>
                            <?php if($user_role != $auth_branch): ?>
                                <?php if( in_array($user_role ,[$admin]) || auth()->user()->can('manage-branches') ): ?>
                                    <td><a href="<?php echo e(route('branches.show',$shipment->branch_id)); ?>"><?php echo e(($shipment->branch->name) ?? 'No Branch Name'); ?></a></td>
                                <?php else: ?>
                                    <td><?php echo e(($shipment->branch->name) ?? 'No Branch Name'); ?></td>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <td><?php echo e(format_price($shipment->tax + $shipment->shipping_cost + $shipment->insurance)); ?></td>
                            <td><?php echo e($shipment->payment_method_id); ?></td>
                            <td><?php echo e($shipment->shipping_date); ?></td>

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>

            </div>
        </div>
        <!--end::Card-->
    </div>
<?php endif; ?>

<?php if(in_array($user_role ,[$admin,$auth_branch]) || auth()->user()->can('manage-drivers') ): ?>
    <div class="col-md-12">
        <div class="card card-custom card-stretch">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label"><?php echo e(__('cargo::view.drivers_wallet')); ?></h3>
                </div>
            </div>
            <div class="card-body">

                <table class="table mb-0 aiz-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('cargo::view.table.code')); ?></th>
                            <th><?php echo e(__('cargo::view.table.name')); ?></th>
                            <th><?php echo e(__('cargo::view.wallet')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $captains; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$captain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php
                                $captain->wallet = abs($captain->wallet);
                            ?>

                            <?php if($captain->wallet > 0 ?? 0): ?>
                                <tr>
                                    <td><a href="<?php echo e(route('drivers.show',$captain->id)); ?>"><?php echo e($captain->code); ?></a></td>
                                    <td><?php echo e($captain->name); ?></td>
                                    <td><?php echo e(format_price($captain->wallet)); ?></td>
                                </tr>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>

            </div>
        </div>
        <!--end::Card-->

    </div>
    <div class="col-md-12">
        <div class="card card-custom card-stretch">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label"><?php echo e(__('cargo::view.drivers_custody')); ?></h3>
                </div>
            </div>
            <div class="card-body">


                <table class="table mb-0 aiz-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('cargo::view.table.code')); ?></th>
                            <th><?php echo e(__('cargo::view.status')); ?></th>
                            <th><?php echo e(__('cargo::view.table.type')); ?></th>
                            <th><?php echo e(__('cargo::view.client')); ?></th>

                            <?php if($user_role != $auth_branch): ?>
                                <th><?php echo e(__('cargo::view.table.branch')); ?></th>
                            <?php endif; ?>

                            <th><?php echo e(__('cargo::view.shipping_cost')); ?></th>
                            <th><?php echo e(__('cargo::view.payment_method')); ?></th>
                            <th><?php echo e(__('cargo::view.shipping_date')); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__currentLoopData = $captains; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$captain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $count      = (Modules\Cargo\Entities\ShipmentSetting::getVal('latest_shipment_count') ? Modules\Cargo\Entities\ShipmentSetting::getVal('latest_shipment_count') : 10 );
                                $shipments  = Modules\Cargo\Entities\Shipment::where('captain_id', $captain->id)->limit($count)->orderBy('id','desc')->get();
                            ?>
                            <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td width="5%"><a href="<?php echo e(route('shipments.show',$shipment->id)); ?>"><?php echo e($shipment->code); ?></a></td>
                                    <td><?php echo e($shipment->getStatus()); ?></td>
                                    <td><?php echo e($shipment->type); ?></td>
                                    <td>
                                        <?php if(in_array($user_role ,[$admin,$auth_branch]) || auth()->user()->can('manage-customers') ): ?>
                                            <a href="<?php echo e(route('clients.show',$shipment->client_id)); ?>"><?php echo e($shipment->client->name ?? 'No Client Name'); ?></a>
                                        <?php else: ?>
                                            <?php echo e($shipment->client->name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <?php if($user_role != $auth_branch): ?>
                                        <?php if( in_array($user_role ,[$admin]) || auth()->user()->can('manage-branches') ): ?>
                                            <td><a href="<?php echo e(route('branches.show',$shipment->branch_id)); ?>"><?php echo e(($shipment->branch->name) ?? 'No Branch Name'); ?></a></td>
                                        <?php else: ?>
                                            <td><?php echo e(($shipment->branch->name) ?? 'No Branch Name'); ?></td>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    
                                    <td><?php echo e(format_price($shipment->tax + $shipment->shipping_cost + $shipment->insurance)); ?></td>
                                    <td><?php echo e($shipment->payment_method_id); ?></td>
                                    <td><?php echo e($shipment->shipping_date); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>

            </div>
        </div>
        <!--end::Card-->

    </div>
<?php endif; ?>

<?php if($user_role == $auth_driver): ?>
    <div class="col-md-12">
        <div class="card card-custom card-stretch">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label"><?php echo e(__('cargo::view.current_manifest')); ?></h3>
                </div>
            </div>
            <div class="card-body">

                <?php
                    $missions  = Modules\Cargo\Entities\Mission::where('captain_id',$driver_id)->whereNotIn('status_id', [\Modules\Cargo\Entities\Mission::DONE_STATUS, \Modules\Cargo\Entities\Mission::CLOSED_STATUS])->where('due_date',Carbon\Carbon::today()->format('Y-m-d'))->get();
                ?>

                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th width="3%"></th>
                                <th><?php echo e(__('cargo::view.table.code')); ?></th>
                                <th><?php echo e(__('cargo::view.table.type')); ?></th>
                                <th><?php echo e(__('cargo::view.amount')); ?></th>
                                <th><?php echo e(__('cargo::view.table.address')); ?></th>
                                <th><?php echo e(__('cargo::view.arrived')); ?></th>


                            </tr>
                        </thead>
                        <tbody id="profile_manifest">

                            <?php $__currentLoopData = $missions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$mission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr style="background-color:tomatom">
                                <td></td>
                                <td width="5%"><?php echo e($mission->code); ?></td>
                                <td><?php echo e($mission->type); ?></td>
                                <?php
                                    $helper = new Modules\Cargo\Http\Helpers\TransactionHelper();
                                    $mission_cost = $helper->calcMissionShipmentsAmount($mission->getRawOriginal('type'),$mission->id);
                                ?>
                                <td><?php echo e(format_price($mission_cost)); ?></td>
                                <td><?php echo e($mission->address); ?></td>
                                <td>
                                    <div style="width: 55%;height: 30px;border: 1px solid;border-radius: 3px;"></div>
                                </td>


                            </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>

            </div>
        </div>
        <!--end::Card-->
    </div>

    <div class="col-md-12">
        <div class="card card-custom card-stretch">
            <div class="card-header">
                <div class="card-title">
                    <h3 class="card-label"><?php echo e(__('cargo::view.active_missions')); ?></h3>
                </div>
            </div>
            <div class="card-body">

                <table class="table mb-0 aiz-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('cargo::view.table.code')); ?></th>
                            <th><?php echo e(__('cargo::view.status')); ?></th>
                            <th><?php echo e(__('cargo::view.table.type')); ?></th>
                            <th><?php echo e(__('cargo::view.amount')); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                            $count      = (Modules\Cargo\Entities\ShipmentSetting::getVal('latest_shipment_count') ? Modules\Cargo\Entities\ShipmentSetting::getVal('latest_shipment_count') : 10 );
                            $missions = Modules\Cargo\Entities\Mission::limit($count)->orderBy('id','desc')->where('captain_id',$driver_id)->whereNotIn('status_id', [\Modules\Cargo\Entities\Mission::DONE_STATUS, \Modules\Cargo\Entities\Mission::CLOSED_STATUS])->where('due_date', \Carbon\Carbon::today()->format('Y-m-d'))->get();
                        ?>
                        <?php $__currentLoopData = $missions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$mission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td width="5%"><a href="<?php echo e(route('missions.show',$mission->id)); ?>"><?php echo e($mission->code); ?></a></td>
                            <td><?php echo e($mission->getStatus()); ?></td>
                            <td><?php echo e($mission->type); ?></td>
                            <?php
                                $helper = new Modules\Cargo\Http\Helpers\TransactionHelper();
                                $mission_cost = $helper->calcMissionShipmentsAmount($mission->getRawOriginal('type'),$mission->id);
                            ?>
                            <td><?php echo e(format_price($mission_cost)); ?></td>
                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>

            </div>
        </div>
        <!--end::Card-->
    </div>
<?php endif; ?><?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/components/dashboard_latest_list.blade.php ENDPATH**/ ?>