<?php if(in_array('role', $filters)): ?>

    <div class="mb-10">
        <!--begin::Label-->
        <label class="form-label fs-5 fw-bold mb-3"><?php echo e(__('users::view.table.role')); ?>:</label>
        <!--end::Label-->
        <!--begin::Options-->
        <div class="d-flex flex-column flex-wrap fw-bold">
            <?php $__currentLoopData = config('cms.user_roles'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $titleRole): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!--begin::Option-->
                <label class="form-check form-check-sm form-check-custom form-check-solid mb-3 me-5" for="<?php echo e($titleRole . $value); ?>">
                    <input class="form-check-input" name="<?php echo e($table_id); ?>_role[]" type="checkbox" value="<?php echo e($value); ?>" id="<?php echo e($titleRole . $value); ?>" >
                    <span class="form-check-label text-gray-600 " style="margin-left: 2.55rem;" ><?php echo e($titleRole); ?></span>
                </label>
                <!--end::Option-->
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <!--end::Options-->
    </div>

    
    <?php $__env->startPush('js-component'); ?>
        <script>
            $(window).on('load', function() {
                setTimeout(() => {
                    var table_id = '<?php echo e($table_id); ?>';
                    var roleCheckbox = $(`[name="${ table_id }_role[]"]`)
                    var dataTableInstance = $(`#${table_id}`).DataTable();
                    var formOptions = $(`#${table_id}_filter_options_form`);

                    roleCheckbox.on('change', function (e) {

                        var value = $(this).val(),
                            roles = [],
                            roleCheckboxChecked = roleCheckbox.filter(':checked')

                        // get multi roles
                        roleCheckboxChecked.each(function (i) {
                            roles.push($(this).val())
                        })
                        // get data by selected roles
                        dataTableInstance.on('preXhr.dt', function (e, settings, data) {

                            console.log(data);
                            if (!data.filter) {
                                data.filter = {}
                            }
                            data.filter.role = roles


                        })
                        // dataTableInstance.ajax.reload()
                    })

                    formOptions.on('reset', function(e) {
                        dataTableInstance.on('preXhr.dt', function (e, settings, data) {
                            if (data.filter) {
                                data.filter.role = ''
                            }
                        })
                        dataTableInstance.ajax.reload()
                    })
                }, 1000);
            });
        </script>
    <?php $__env->stopPush(); ?>


<?php endif; ?>







<?php /**PATH C:\xampp\htdocs\Modules/Users\Resources/views/adminLte/pages/users/table/filters/role.blade.php ENDPATH**/ ?>